/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.global.preprocessor.css.smartsprites;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.BinaryResourcesHandler;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.global.preprocessor.GlobalPreprocessingContext;
import net.jawr.web.resource.bundle.global.preprocessor.css.smartsprites.CssSmartSpritesResourceReader;
import net.jawr.web.resource.bundle.global.preprocessor.css.smartsprites.SmartSpritesResourceHandler;
import net.jawr.web.resource.bundle.global.processor.AbstractChainedGlobalProcessor;
import net.jawr.web.resource.bundle.iterator.BundlePath;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import org.apache.commons.io.FileUtils;
import org.carrot2.labs.smartsprites.SmartSpritesParameters;
import org.carrot2.labs.smartsprites.SpriteBuilder;
import org.carrot2.labs.smartsprites.message.Message;
import org.carrot2.labs.smartsprites.message.MessageLog;
import org.carrot2.labs.smartsprites.message.MessageSink;
import org.carrot2.labs.smartsprites.resource.ResourceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssSmartSpritesGlobalPreprocessor
extends AbstractChainedGlobalProcessor<GlobalPreprocessingContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CssSmartSpritesGlobalPreprocessor.class);
    private static final String ERROR_LEVEL = "ERROR";
    private static final String WARN_LEVEL = "WARN";
    private static final String INFO_LEVEL = "INFO";

    public CssSmartSpritesGlobalPreprocessor() {
        super("smartsprites");
    }

    @Override
    public void processBundles(GlobalPreprocessingContext ctx, List<JoinableResourceBundle> bundles) {
        ResourceReaderHandler rsHandler = ctx.getRsReaderHandler();
        Set<String> resourcePaths = this.getResourcePaths(bundles);
        JawrConfig jawrConfig = ctx.getJawrConfig();
        Charset charset = jawrConfig.getResourceCharset();
        BinaryResourcesHandler binaryRsHandler = (BinaryResourcesHandler)jawrConfig.getContext().getAttribute("net.jawr.web.resource.bundle.BINARY_CONTEXT_ATTRIBUTE");
        this.generateSprites(rsHandler, binaryRsHandler, resourcePaths, jawrConfig, charset);
        CssSmartSpritesResourceReader cssSpriteResourceReader = new CssSmartSpritesResourceReader(rsHandler.getWorkingDirectory(), jawrConfig);
        this.updateBundlesDirtyState(bundles, cssSpriteResourceReader);
        ctx.getRsReaderHandler().addResourceReader(cssSpriteResourceReader);
        ResourceReaderHandler imgStreamRsHandler = binaryRsHandler.getRsReaderHandler();
        imgStreamRsHandler.addResourceReader(cssSpriteResourceReader);
    }

    private void updateBundlesDirtyState(List<JoinableResourceBundle> bundles, CssSmartSpritesResourceReader cssSpriteResourceReader) {
        block2: for (JoinableResourceBundle bundle : bundles) {
            List<BundlePath> bundlePaths = bundle.getItemPathList();
            for (BundlePath bundlePath : bundlePaths) {
                String path = bundlePath.getPath();
                File stdFile = cssSpriteResourceReader.getGeneratedCssFile(path);
                File bckFile = cssSpriteResourceReader.getBackupFile(path);
                if (bckFile.exists()) {
                    try {
                        if (!FileUtils.contentEquals((File)stdFile, (File)bckFile)) {
                            bundle.setDirty(true);
                            continue block2;
                        }
                    }
                    catch (IOException e) {
                        throw new BundlingProcessException("Issue while generating smartsprite bundle", e);
                    }
                }
                cssSpriteResourceReader.getResource(bundle, path);
            }
        }
    }

    private void generateSprites(ResourceReaderHandler cssRsHandler, BinaryResourcesHandler binaryRsHandler, Set<String> resourcePaths, JawrConfig jawrConfig, Charset charset) {
        Message.MessageLevel msgLevel = Message.MessageLevel.valueOf((String)ERROR_LEVEL);
        String sinkLevel = WARN_LEVEL;
        if (LOGGER.isTraceEnabled() || LOGGER.isDebugEnabled() || LOGGER.isInfoEnabled()) {
            msgLevel = Message.MessageLevel.valueOf((String)INFO_LEVEL);
            sinkLevel = INFO_LEVEL;
        } else if (LOGGER.isWarnEnabled() || LOGGER.isErrorEnabled()) {
            msgLevel = Message.MessageLevel.valueOf((String)WARN_LEVEL);
            sinkLevel = WARN_LEVEL;
        }
        MessageLog messageLog = new MessageLog(new MessageSink[]{new LogMessageSink(sinkLevel)});
        SmartSpritesResourceHandler smartSpriteRsHandler = new SmartSpritesResourceHandler(cssRsHandler, binaryRsHandler.getRsReaderHandler(), jawrConfig.getGeneratorRegistry(), binaryRsHandler.getConfig().getGeneratorRegistry(), charset.toString(), messageLog);
        smartSpriteRsHandler.setContextPath(jawrConfig.getProperty("jawr.css.url.rewriter.context.path"));
        String outDir = cssRsHandler.getWorkingDirectory() + "/cssSprites/src/";
        File tmpDir = new File(outDir);
        if (!tmpDir.exists()) {
            if (!tmpDir.mkdirs()) {
                throw new BundlingProcessException("Impossible to create temporary directory : " + tmpDir);
            }
        } else {
            try {
                File backupDir = new File(cssRsHandler.getWorkingDirectory() + "/backupGeneratedCss/");
                if (!backupDir.exists() && !backupDir.mkdirs()) {
                    throw new BundlingProcessException("Impossible to create temporary directory : " + backupDir);
                }
                FileUtils.copyDirectory((File)tmpDir, (File)backupDir);
                FileUtils.cleanDirectory((File)tmpDir);
            }
            catch (IOException e) {
                throw new BundlingProcessException("Impossible to clean temporary directory : " + outDir, e);
            }
        }
        SmartSpritesParameters params = new SmartSpritesParameters("/", null, outDir, null, msgLevel, "", SmartSpritesParameters.PngDepth.valueOf((String)"AUTO"), false, charset.toString(), true);
        SpriteBuilder spriteBuilder = new SpriteBuilder(params, messageLog, (ResourceHandler)smartSpriteRsHandler);
        try {
            spriteBuilder.buildSprites(resourcePaths);
        }
        catch (IOException e) {
            throw new BundlingProcessException("Unable to build sprites", e);
        }
    }

    private Set<String> getResourcePaths(List<JoinableResourceBundle> bundles) {
        HashSet<String> resourcePaths = new HashSet<String>();
        for (JoinableResourceBundle bundle : bundles) {
            for (BundlePath bundlePath : bundle.getItemPathList()) {
                resourcePaths.add(bundlePath.getPath());
            }
        }
        return resourcePaths;
    }

    private static class LogMessageSink
    implements MessageSink {
        private final String logLevel;

        public LogMessageSink(String logLevel) {
            this.logLevel = logLevel != null ? logLevel : CssSmartSpritesGlobalPreprocessor.INFO_LEVEL;
        }

        public void add(Message message) {
            if (LOGGER.isInfoEnabled() && this.logLevel.equals(CssSmartSpritesGlobalPreprocessor.INFO_LEVEL) && this.logLevelGreaterOrEqualThan(message.level, Message.MessageLevel.INFO)) {
                LOGGER.info(message.getFormattedMessage());
            } else if (LOGGER.isWarnEnabled() && this.logLevel.equals(CssSmartSpritesGlobalPreprocessor.WARN_LEVEL) && this.logLevelGreaterOrEqualThan(message.level, Message.MessageLevel.WARN)) {
                LOGGER.warn(message.getFormattedMessage());
            } else if (LOGGER.isErrorEnabled() && this.logLevel.equals(CssSmartSpritesGlobalPreprocessor.ERROR_LEVEL) && this.logLevelGreaterOrEqualThan(message.level, Message.MessageLevel.ERROR)) {
                LOGGER.error(message.getFormattedMessage());
            }
        }

        private boolean logLevelGreaterOrEqualThan(Message.MessageLevel msgLevel1, Message.MessageLevel msgLevel2) {
            return Message.MessageLevel.COMPARATOR.compare(msgLevel1, msgLevel2) >= 0;
        }
    }
}

