/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.global.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.global.processor.AbstractChainedGlobalProcessor;
import net.jawr.web.resource.bundle.global.processor.AbstractGlobalProcessingContext;
import net.jawr.web.resource.bundle.global.processor.ChainedGlobalProcessor;
import net.jawr.web.resource.bundle.global.processor.CustomGlobalProcessorChainedWrapper;
import net.jawr.web.resource.bundle.global.processor.EmptyGlobalProcessor;
import net.jawr.web.resource.bundle.global.processor.GlobalProcessor;
import net.jawr.web.resource.bundle.global.processor.GlobalProcessorChainFactory;
import net.jawr.web.resource.bundle.lifecycle.BundlingProcessLifeCycleListener;

public abstract class AbstractGlobalProcessorChainFactory<T extends AbstractGlobalProcessingContext>
implements GlobalProcessorChainFactory<T> {
    private Map<String, ChainedGlobalProcessor<T>> customPostprocessors = new HashMap<String, ChainedGlobalProcessor<T>>();
    private final List<BundlingProcessLifeCycleListener> listeners = new ArrayList<BundlingProcessLifeCycleListener>();

    @Override
    public void setCustomGlobalProcessors(Map<String, String> keysClassNames) {
        for (Map.Entry<String, String> entry : keysClassNames.entrySet()) {
            GlobalProcessor customGlobalPreprocessor = (GlobalProcessor)ClassLoaderResourceUtils.buildObjectInstance(entry.getValue());
            String key = entry.getKey();
            this.customPostprocessors.put(key, new CustomGlobalProcessorChainedWrapper(key, customGlobalPreprocessor));
        }
    }

    @Override
    public GlobalProcessor<T> buildDefaultProcessorChain() {
        return new EmptyGlobalProcessor();
    }

    @Override
    public GlobalProcessor<T> buildProcessorChain(String processorKeys) {
        if (null == processorKeys) {
            return null;
        }
        if ("none".equals(processorKeys)) {
            return new EmptyGlobalProcessor();
        }
        StringTokenizer tk = new StringTokenizer(processorKeys, ",");
        AbstractChainedGlobalProcessor<T> chain = null;
        while (tk.hasMoreTokens()) {
            chain = this.addOrCreateChain(chain, tk.nextToken());
        }
        return chain;
    }

    private AbstractChainedGlobalProcessor<T> addOrCreateChain(AbstractChainedGlobalProcessor<T> chain, String key) {
        AbstractChainedGlobalProcessor<T> toAdd = this.customPostprocessors.get(key) == null ? this.buildProcessorByKey(key) : (AbstractChainedGlobalProcessor<T>)this.customPostprocessors.get(key);
        if (toAdd instanceof BundlingProcessLifeCycleListener && !this.listeners.contains(toAdd)) {
            this.listeners.add((BundlingProcessLifeCycleListener)((Object)toAdd));
        }
        AbstractChainedGlobalProcessor<T> newChainResult = null;
        if (chain == null) {
            newChainResult = toAdd;
        } else {
            chain.addNextProcessor(toAdd);
            newChainResult = chain;
        }
        return newChainResult;
    }

    protected abstract AbstractChainedGlobalProcessor<T> buildProcessorByKey(String var1);

    @Override
    public List<BundlingProcessLifeCycleListener> getBundlingProcessLifeCycleListeners() {
        return this.listeners;
    }
}

