/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.variant.VariantUtils;
import net.jawr.web.servlet.RendererRequestUtils;

public class ClientSideHandlerScriptRequestHandler
implements Serializable {
    private static final long serialVersionUID = 5891646272143678994L;
    private static final long START_TIME = System.currentTimeMillis();
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_IF_NONE = "If-None-Match";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_IF_MODIFIED = "If-Modified-Since";
    private static final String JAVASCRIPT_CONTENT_TYPE = "text/javascript";
    public static final String HEADER_USER_AGENT = "User-Agent";
    private final ResourceBundlesHandler rsHandler;
    private final JawrConfig config;
    private final Map<String, Handler> handlerCache;

    public ClientSideHandlerScriptRequestHandler(ResourceBundlesHandler rsHandler, JawrConfig config) {
        this.rsHandler = rsHandler;
        this.config = config;
        this.handlerCache = new ConcurrentHashMap<String, Handler>();
    }

    public void handleClientSideHandlerRequest(HttpServletRequest request, HttpServletResponse response) {
        Handler handler;
        Map<String, String> variants = this.config.getGeneratorRegistry().resolveVariants(request);
        String variantKey = VariantUtils.getVariantKey(variants);
        if (this.handlerCache.containsKey(variantKey)) {
            handler = this.handlerCache.get(variantKey);
        } else {
            StringBuffer sb = this.rsHandler.getClientSideHandler().getClientSideHandlerScript(request);
            handler = new Handler(sb, Integer.toString(sb.hashCode()));
            this.handlerCache.put(variantKey, handler);
        }
        if (this.useNotModifiedHeader(request, handler.hash)) {
            response.setStatus(304);
            return;
        }
        response.setHeader(HEADER_ETAG, handler.hash);
        response.setDateHeader(HEADER_LAST_MODIFIED, START_TIME);
        response.setContentType(JAVASCRIPT_CONTENT_TYPE);
        if (RendererRequestUtils.isRequestGzippable(request, this.config)) {
            try {
                response.setHeader("Content-Encoding", "gzip");
                GZIPOutputStream gzOut = new GZIPOutputStream((OutputStream)response.getOutputStream());
                byte[] data = handler.data.toString().getBytes(this.config.getResourceCharset().name());
                gzOut.write(data, 0, data.length);
                gzOut.close();
            }
            catch (IOException e) {
                throw new BundlingProcessException("Unexpected IOException writing ClientSideHandlerScript", e);
            }
        }
        StringReader rd = new StringReader(handler.data.toString());
        try {
            PrintWriter writer = response.getWriter();
            IOUtils.copy(rd, writer, true);
        }
        catch (IOException e) {
            throw new BundlingProcessException("Unexpected IOException writing ClientSideHandlerScript", e);
        }
    }

    private boolean useNotModifiedHeader(HttpServletRequest request, String scriptEtag) {
        long modifiedHeader = -1L;
        try {
            modifiedHeader = request.getDateHeader(HEADER_IF_MODIFIED);
            if (modifiedHeader != -1L) {
                modifiedHeader -= modifiedHeader % 1000L;
            }
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        String eTag = request.getHeader(HEADER_IF_NONE);
        if (modifiedHeader == -1L) {
            return scriptEtag.equals(eTag);
        }
        if (null == eTag) {
            return modifiedHeader <= START_TIME;
        }
        return scriptEtag.equals(eTag) && modifiedHeader <= START_TIME;
    }

    private static class Handler
    implements Serializable {
        private static final long serialVersionUID = -8016918532036667397L;
        String hash;
        StringBuffer data;

        Handler(StringBuffer data, String hash) {
            this.data = data;
            this.hash = hash;
        }
    }
}

