/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.handler;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPOutputStream;
import net.jawr.web.DebugMode;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.context.ThreadLocalJawrContext;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.InterruptBundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.BinaryResourcesHandler;
import net.jawr.web.resource.bundle.CheckSumUtils;
import net.jawr.web.resource.bundle.CompositeResourceBundle;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.JoinableResourceBundleContent;
import net.jawr.web.resource.bundle.JoinableResourceBundlePropertySerializer;
import net.jawr.web.resource.bundle.factory.global.postprocessor.GlobalPostProcessingContext;
import net.jawr.web.resource.bundle.factory.global.preprocessor.GlobalPreprocessingContext;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.global.processor.GlobalProcessor;
import net.jawr.web.resource.bundle.handler.BundleHashcodeType;
import net.jawr.web.resource.bundle.handler.ClientSideHandlerGenerator;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.hashcode.BundleHashcodeGenerator;
import net.jawr.web.resource.bundle.iterator.AbstractPathsIterator;
import net.jawr.web.resource.bundle.iterator.BundlePath;
import net.jawr.web.resource.bundle.iterator.ConditionalCommentCallbackHandler;
import net.jawr.web.resource.bundle.iterator.DebugModePathsIteratorImpl;
import net.jawr.web.resource.bundle.iterator.IECssDebugPathsIteratorImpl;
import net.jawr.web.resource.bundle.iterator.PathsIteratorImpl;
import net.jawr.web.resource.bundle.iterator.ResourceBundlePathsIterator;
import net.jawr.web.resource.bundle.lifecycle.BundlingProcessLifeCycleListener;
import net.jawr.web.resource.bundle.postprocess.AbstractChainedResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import net.jawr.web.resource.bundle.postprocess.ResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.sorting.GlobalResourceBundleComparator;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.resource.bundle.variant.VariantUtils;
import net.jawr.web.resource.handler.bundle.ResourceBundleHandler;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.resource.watcher.ResourceWatcher;
import net.jawr.web.util.StopWatch;
import net.jawr.web.util.StringUtils;
import net.jawr.web.util.bom.UnicodeBOMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundlesHandlerImpl
implements ResourceBundlesHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundlesHandler.class);
    private List<JoinableResourceBundle> bundles;
    private List<JoinableResourceBundle> globalBundles;
    private List<JoinableResourceBundle> contextBundles;
    private Map<String, List<JoinableResourceBundle>> compositeResourceBundleMap = new ConcurrentHashMap<String, List<JoinableResourceBundle>>();
    private List<String> bundlePrefixes;
    private List<String> liveProcessBundles = new ArrayList<String>();
    private ResourceReaderHandler resourceHandler;
    private ResourceBundleHandler resourceBundleHandler;
    private JawrConfig config;
    private ResourceBundlePostProcessor postProcessor;
    private ResourceBundlePostProcessor unitaryPostProcessor;
    private ResourceBundlePostProcessor compositePostProcessor;
    private ResourceBundlePostProcessor unitaryCompositePostProcessor;
    private GlobalProcessor<GlobalPreprocessingContext> resourceTypePreprocessor;
    private GlobalProcessor<GlobalPostProcessingContext> resourceTypePostprocessor;
    private ClientSideHandlerGenerator clientSideHandlerGenerator;
    private BundleHashcodeGenerator bundleHashcodeGenerator;
    private Properties bundleMapping;
    private final AtomicBoolean processingBundle = new AtomicBoolean(false);
    private ResourceWatcher watcher;
    private final List<BundlingProcessLifeCycleListener> lifeCycleListeners = new CopyOnWriteArrayList<BundlingProcessLifeCycleListener>();
    private boolean needToSearchForVariantInPostProcess;

    public ResourceBundlesHandlerImpl(List<JoinableResourceBundle> bundles, ResourceReaderHandler resourceHandler, ResourceBundleHandler resourceBundleHandler, JawrConfig config) {
        this(bundles, resourceHandler, resourceBundleHandler, config, null, null, null, null, null, null);
    }

    public ResourceBundlesHandlerImpl(List<JoinableResourceBundle> bundles, ResourceReaderHandler resourceHandler, ResourceBundleHandler resourceBundleHandler, JawrConfig config, ResourceBundlePostProcessor postProcessor, ResourceBundlePostProcessor unitaryPostProcessor, ResourceBundlePostProcessor compositePostProcessor, ResourceBundlePostProcessor unitaryCompositePostProcessor, GlobalProcessor<GlobalPreprocessingContext> resourceTypePreprocessor, GlobalProcessor<GlobalPostProcessingContext> resourceTypePostprocessor) {
        this.resourceHandler = resourceHandler;
        this.resourceBundleHandler = resourceBundleHandler;
        this.config = config;
        this.bundleHashcodeGenerator = config.getBundleHashcodeGenerator();
        this.postProcessor = postProcessor;
        this.unitaryPostProcessor = unitaryPostProcessor;
        this.compositePostProcessor = compositePostProcessor;
        this.unitaryCompositePostProcessor = unitaryCompositePostProcessor;
        this.resourceTypePreprocessor = resourceTypePreprocessor;
        this.resourceTypePostprocessor = resourceTypePostprocessor;
        this.bundles = new CopyOnWriteArrayList<JoinableResourceBundle>();
        this.bundles.addAll(bundles);
        this.splitBundlesByType(bundles);
        this.clientSideHandlerGenerator = (ClientSideHandlerGenerator)ClassLoaderResourceUtils.buildObjectInstance(config.getClientSideHandlerGeneratorClass());
        this.clientSideHandlerGenerator.init(config, this.globalBundles, this.contextBundles);
        this.needToSearchForVariantInPostProcess = this.isSearchingForVariantInPostProcessNeeded();
        List<BundlingProcessLifeCycleListener> generatorLifeCycleListeners = config.getGeneratorRegistry().getBundlingProcessLifeCycleListeners();
        this.lifeCycleListeners.addAll(generatorLifeCycleListeners);
    }

    @Override
    public AtomicBoolean isProcessingBundle() {
        return this.processingBundle;
    }

    private boolean isSearchingForVariantInPostProcessNeeded() {
        ResourceBundlePostProcessor[] postprocessors;
        boolean needToSearch = false;
        for (ResourceBundlePostProcessor resourceBundlePostProcessor : postprocessors = new ResourceBundlePostProcessor[]{this.postProcessor, this.unitaryCompositePostProcessor, this.compositePostProcessor, this.unitaryCompositePostProcessor}) {
            if (resourceBundlePostProcessor == null || !((AbstractChainedResourceBundlePostProcessor)resourceBundlePostProcessor).isVariantPostProcessor()) continue;
            needToSearch = true;
            break;
        }
        return needToSearch;
    }

    @Override
    public String getResourceType() {
        return this.resourceBundleHandler.getResourceType();
    }

    @Override
    public List<JoinableResourceBundle> getContextBundles() {
        return this.contextBundles;
    }

    @Override
    public List<JoinableResourceBundle> getGlobalBundles() {
        return this.globalBundles;
    }

    private void splitBundlesByType(List<JoinableResourceBundle> bundles) {
        ArrayList<JoinableResourceBundle> tmpGlobal = new ArrayList<JoinableResourceBundle>();
        ArrayList<JoinableResourceBundle> tmpContext = new ArrayList<JoinableResourceBundle>();
        for (JoinableResourceBundle bundle : bundles) {
            if (bundle.getInclusionPattern().isGlobal()) {
                tmpGlobal.add(bundle);
                continue;
            }
            tmpContext.add(bundle);
        }
        Collections.sort(tmpGlobal, new GlobalResourceBundleComparator());
        this.globalBundles = new CopyOnWriteArrayList<JoinableResourceBundle>();
        this.globalBundles.addAll(tmpGlobal);
        this.contextBundles = new CopyOnWriteArrayList<JoinableResourceBundle>();
        this.contextBundles.addAll(tmpContext);
        this.initBundlePrefixes();
        this.initCompositeBundleMap(this.globalBundles);
        this.initCompositeBundleMap(this.contextBundles);
    }

    protected void initBundlePrefixes() {
        this.bundlePrefixes = new CopyOnWriteArrayList<String>();
        for (JoinableResourceBundle bundle : this.globalBundles) {
            if (!StringUtils.isNotEmpty(bundle.getBundlePrefix())) continue;
            this.bundlePrefixes.add(bundle.getBundlePrefix());
        }
        for (JoinableResourceBundle bundle : this.contextBundles) {
            if (!StringUtils.isNotEmpty(bundle.getBundlePrefix())) continue;
            this.bundlePrefixes.add(bundle.getBundlePrefix());
        }
    }

    private void initCompositeBundleMap(List<JoinableResourceBundle> bundles) {
        for (JoinableResourceBundle bundle : bundles) {
            if (!bundle.isComposite()) continue;
            List<JoinableResourceBundle> childBundles = ((CompositeResourceBundle)bundle).getChildBundles();
            for (JoinableResourceBundle childBundle : childBundles) {
                List<JoinableResourceBundle> associatedBundles = this.compositeResourceBundleMap.get(childBundle.getId());
                if (associatedBundles == null) {
                    associatedBundles = new ArrayList<JoinableResourceBundle>();
                }
                associatedBundles.add(bundle);
                this.compositeResourceBundleMap.put(childBundle.getId(), associatedBundles);
            }
        }
    }

    @Override
    public boolean isGlobalResourceBundle(String resourceBundleId) {
        boolean isGlobalResourceBundle = false;
        for (JoinableResourceBundle bundle : this.globalBundles) {
            if (!bundle.getId().equals(resourceBundleId)) continue;
            isGlobalResourceBundle = true;
        }
        return isGlobalResourceBundle;
    }

    @Override
    public ResourceBundlePathsIterator getGlobalResourceBundlePaths(DebugMode debugMode, ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        return this.getBundleIterator(debugMode, this.globalBundles, commentCallbackHandler, variants);
    }

    @Override
    public ResourceBundlePathsIterator getGlobalResourceBundlePaths(ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        return this.getBundleIterator(this.getDebugMode(), this.globalBundles, commentCallbackHandler, variants);
    }

    @Override
    public ResourceBundlePathsIterator getGlobalResourceBundlePaths(String bundleId, ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        ArrayList<JoinableResourceBundle> currentBundles = new ArrayList<JoinableResourceBundle>();
        for (JoinableResourceBundle bundle : this.globalBundles) {
            if (!bundle.getId().equals(bundleId)) continue;
            currentBundles.add(bundle);
            break;
        }
        return this.getBundleIterator(this.getDebugMode(), currentBundles, commentCallbackHandler, variants);
    }

    @Override
    public ResourceBundlePathsIterator getBundlePaths(String bundleId, ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        return this.getBundlePaths(this.getDebugMode(), bundleId, commentCallbackHandler, variants);
    }

    @Override
    public ResourceBundlePathsIterator getBundlePaths(DebugMode debugMode, String bundleId, ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        ArrayList<JoinableResourceBundle> currentBundles = new ArrayList<JoinableResourceBundle>();
        if (!this.isGlobalResourceBundle(bundleId)) {
            for (JoinableResourceBundle bundle : this.contextBundles) {
                if (!bundle.getId().equals(bundleId)) continue;
                currentBundles.add(bundle);
                break;
            }
        }
        return this.getBundleIterator(debugMode, currentBundles, commentCallbackHandler, variants);
    }

    private ResourceBundlePathsIterator getBundleIterator(DebugMode debugMode, List<JoinableResourceBundle> bundles, ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        AbstractPathsIterator bundlesIterator = debugMode.equals((Object)DebugMode.DEBUG) ? new DebugModePathsIteratorImpl(bundles, commentCallbackHandler, variants) : (debugMode.equals((Object)DebugMode.FORCE_NON_DEBUG_IN_IE) ? new IECssDebugPathsIteratorImpl(bundles, commentCallbackHandler, variants) : new PathsIteratorImpl(bundles, commentCallbackHandler, variants));
        return bundlesIterator;
    }

    @Override
    public void writeBundleTo(String bundlePath, Writer writer) throws ResourceNotFoundException {
        Reader rd = null;
        try {
            if (this.config.isDebugModeOn()) {
                rd = this.resourceHandler.getResource(null, bundlePath);
            } else {
                for (String prefix : this.bundlePrefixes) {
                    if (!bundlePath.startsWith(prefix)) continue;
                    bundlePath = bundlePath.substring(prefix.length());
                    break;
                }
                String path = PathNormalizer.removeVariantPrefixFromPath(bundlePath);
                rd = this.resourceBundleHandler.getResourceBundleReader(path);
                if (this.liveProcessBundles.contains(path)) {
                    rd = this.processInLive(rd);
                }
            }
            IOUtils.copy(rd, writer);
            writer.flush();
        }
        catch (IOException e) {
            try {
                throw new BundlingProcessException("Unexpected IOException writing bundle[" + bundlePath + "]", e);
            }
            catch (Throwable throwable) {
                IOUtils.close(rd);
                IOUtils.close(writer);
                throw throwable;
            }
        }
        IOUtils.close(rd);
        IOUtils.close(writer);
    }

    private StringReader processInLive(Reader reader) throws IOException {
        String requestURL = ThreadLocalJawrContext.getRequestURL();
        StringWriter swriter = new StringWriter();
        IOUtils.copy(reader, swriter, true);
        String updatedContent = swriter.getBuffer().toString();
        if (requestURL != null) {
            updatedContent = updatedContent.replaceAll("\\{JAWR_BUNDLE_PATH\\}", requestURL);
        }
        return new StringReader(updatedContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamBundleTo(String bundlePath, OutputStream out) throws ResourceNotFoundException {
        String path = PathNormalizer.removeVariantPrefixFromPath(bundlePath);
        ReadableByteChannel data = null;
        try {
            block20: {
                block19: {
                    if (!this.liveProcessBundles.contains(path)) break block19;
                    Reader rd = null;
                    try {
                        rd = this.resourceBundleHandler.getResourceBundleReader(path);
                        StringReader strRd = this.processInLive(rd);
                        StringWriter strWriter = new StringWriter();
                        IOUtils.copy(strRd, (Writer)strWriter);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        try (GZIPOutputStream gzOut = new GZIPOutputStream(bos);){
                            byte[] byteData = strWriter.getBuffer().toString().getBytes(this.config.getResourceCharset().name());
                            gzOut.write(byteData, 0, byteData.length);
                        }
                        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                        data = Channels.newChannel(bis);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(rd);
                        throw throwable;
                    }
                    IOUtils.close(rd);
                    break block20;
                }
                data = this.resourceBundleHandler.getResourceBundleChannel(path);
            }
            WritableByteChannel outChannel = Channels.newChannel(out);
            IOUtils.copy(data, outChannel);
        }
        catch (IOException e) {
            try {
                throw new BundlingProcessException("Unexpected IOException writing bundle [" + path + "]", e);
            }
            catch (Throwable throwable) {
                IOUtils.close(data);
                throw throwable;
            }
        }
        IOUtils.close(data);
    }

    @Override
    public JawrConfig getConfig() {
        return this.config;
    }

    private DebugMode getDebugMode() {
        return this.config.isDebugModeOn() ? DebugMode.DEBUG : DebugMode.NO_DEBUG;
    }

    @Override
    public void initAllBundles() {
        this.stopProcessIfNeeded();
        if (this.config.getUseBundleMapping()) {
            this.bundleMapping = this.resourceBundleHandler.getJawrBundleMapping();
        }
        boolean mappingFileExists = this.resourceBundleHandler.isExistingMappingFile();
        boolean processBundleFlag = !this.config.getUseBundleMapping() || !mappingFileExists;
        StopWatch stopWatch = ThreadLocalJawrContext.getStopWatch();
        List<JoinableResourceBundle> bundleToProcess = this.bundles;
        boolean forceStoreJawrBundleMapping = false;
        if (!processBundleFlag) {
            boolean rebuildAllBundles;
            String storeJawrConfigHashcode = this.resourceBundleHandler.getJawrBundleMapping().getProperty("jawr.config.hashcode");
            String jawrConfigHashcode = this.getJawrConfigHashcode();
            boolean bl = rebuildAllBundles = !this.config.getUseSmartBundling() || !jawrConfigHashcode.equals(storeJawrConfigHashcode);
            if (!rebuildAllBundles) {
                bundleToProcess = this.getBundlesToRebuild();
                if (!bundleToProcess.isEmpty() && LOGGER.isDebugEnabled()) {
                    StringBuilder msg = new StringBuilder("Jawr has detect changes on the following bundles, which will be updated :\n");
                    for (JoinableResourceBundle b : bundleToProcess) {
                        msg.append(b.getName()).append("\n");
                    }
                    LOGGER.debug(msg.toString());
                }
            } else {
                this.bundleMapping.clear();
                if (LOGGER.isDebugEnabled() && !jawrConfigHashcode.equals(storeJawrConfigHashcode)) {
                    LOGGER.debug("Jawr config has changed since last bundling process. All bundles will be processed.");
                }
            }
            forceStoreJawrBundleMapping = !bundleToProcess.isEmpty();
        }
        this.build(bundleToProcess, forceStoreJawrBundleMapping, stopWatch);
    }

    protected String getJawrConfigHashcode() {
        try {
            return CheckSumUtils.getMD5Checksum(this.config.getConfigProperties().toString());
        }
        catch (IOException e) {
            throw new BundlingProcessException("Unable to calculate Jawr config checksum", e);
        }
    }

    private void executeGlobalPreprocessing(List<JoinableResourceBundle> bundlesToBuild, boolean processBundleFlag, StopWatch stopWatch) {
        this.stopProcessIfNeeded();
        if (this.resourceTypePreprocessor != null) {
            if (stopWatch != null) {
                stopWatch.start("Global preprocessing");
            }
            GlobalPreprocessingContext ctx = new GlobalPreprocessingContext(this.config, this.resourceHandler, processBundleFlag);
            this.resourceTypePreprocessor.processBundles(ctx, this.bundles);
            List<JoinableResourceBundle> currentBundles = this.getBundlesToRebuild();
            for (JoinableResourceBundle b : currentBundles) {
                if (bundlesToBuild.contains(b)) continue;
                bundlesToBuild.add(b);
            }
            if (stopWatch != null) {
                stopWatch.stop();
            }
        }
    }

    @Override
    public synchronized void rebuildModifiedBundles() {
        this.stopProcessIfNeeded();
        StopWatch stopWatch = ThreadLocalJawrContext.getStopWatch();
        if (this.config.getUseSmartBundling()) {
            if (this.watcher != null) {
                while (!this.watcher.hasNoEventToProcess()) {
                    try {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("Wait until there is no more watch event to process");
                        }
                        Thread.sleep(this.config.getSmartBundlingDelayAfterLastEvent());
                    }
                    catch (InterruptedException e) {}
                }
            }
            List<JoinableResourceBundle> bundlesToRebuild = this.getBundlesToRebuild();
            for (JoinableResourceBundle bundle : bundlesToRebuild) {
                bundle.resetBundleMapping();
            }
            this.build(bundlesToRebuild, true, stopWatch);
        } else {
            LOGGER.warn("You should turn on \"smart bundling\" feature to be able to rebuild modified bundles.");
        }
    }

    private List<JoinableResourceBundle> getBundlesToRebuild() {
        ArrayList<JoinableResourceBundle> bundlesToRebuild = new ArrayList<JoinableResourceBundle>();
        if (this.config.getUseSmartBundling()) {
            for (JoinableResourceBundle bundle : this.globalBundles) {
                if (!bundle.isDirty()) continue;
                bundlesToRebuild.add(bundle);
            }
            for (JoinableResourceBundle bundle : this.contextBundles) {
                if (!bundle.isDirty()) continue;
                bundlesToRebuild.add(bundle);
            }
        }
        return bundlesToRebuild;
    }

    public void build(List<JoinableResourceBundle> bundlesToBuild, boolean forceWriteBundleMapping, StopWatch stopWatch) {
        this.stopProcessIfNeeded();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting bundle processing");
        }
        this.notifyStartBundlingProcess();
        boolean mappingFileExists = this.resourceBundleHandler.isExistingMappingFile();
        boolean processBundleFlag = !this.config.getUseBundleMapping() || !mappingFileExists;
        this.executeGlobalPreprocessing(bundlesToBuild, processBundleFlag, stopWatch);
        for (JoinableResourceBundle bundle : bundlesToBuild) {
            this.stopProcessIfNeeded();
            if (stopWatch != null) {
                stopWatch.start("Processing bundle '" + bundle.getName() + "'");
            }
            if (!ThreadLocalJawrContext.isBundleProcessingAtBuildTime() && null != bundle.getAlternateProductionURL() && LOGGER.isDebugEnabled()) {
                LOGGER.debug("No bundle generated for '" + bundle.getId() + "' because a production URL is defined for this bundle.");
            }
            if (bundle instanceof CompositeResourceBundle) {
                this.joinAndStoreCompositeResourcebundle((CompositeResourceBundle)bundle);
            } else {
                this.joinAndStoreBundle(bundle);
            }
            if (this.config.getUseBundleMapping()) {
                JoinableResourceBundlePropertySerializer.serializeInProperties(bundle, this.resourceBundleHandler.getResourceType(), this.bundleMapping);
            }
            bundle.setDirty(false);
            if (stopWatch == null) continue;
            stopWatch.stop();
        }
        this.executeGlobalPostProcessing(processBundleFlag, stopWatch);
        this.storeJawrBundleMapping(this.resourceBundleHandler.isExistingMappingFile(), true);
        try {
            if (this.watcher != null) {
                this.watcher.initPathToResourceBundleMap(bundlesToBuild);
            }
        }
        catch (IOException e) {
            throw new BundlingProcessException(e);
        }
        this.notifyEndBundlingProcess();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("End of bundle processing");
        }
    }

    protected void stopProcessIfNeeded() {
        if (ThreadLocalJawrContext.isInterruptingProcessingBundle()) {
            throw new InterruptBundlingProcessException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStartBundlingProcess() {
        for (BundlingProcessLifeCycleListener listener : this.lifeCycleListeners) {
            listener.beforeBundlingProcess();
        }
        this.processingBundle.set(true);
        AtomicBoolean atomicBoolean = this.processingBundle;
        synchronized (atomicBoolean) {
            this.processingBundle.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyEndBundlingProcess() {
        this.processingBundle.set(false);
        AtomicBoolean atomicBoolean = this.processingBundle;
        synchronized (atomicBoolean) {
            this.processingBundle.notifyAll();
        }
        for (BundlingProcessLifeCycleListener listener : this.lifeCycleListeners) {
            listener.afterBundlingProcess();
        }
    }

    private void storeJawrBundleMapping(boolean mappingFileExists, boolean force) {
        if (this.config.getUseBundleMapping() && (!mappingFileExists || force)) {
            BinaryResourcesHandler binaryRsHandler;
            this.bundleMapping.setProperty("jawr.config.hashcode", this.getJawrConfigHashcode());
            this.resourceBundleHandler.storeJawrBundleMapping(this.bundleMapping);
            if (this.resourceBundleHandler.getResourceType().equals("css") && (binaryRsHandler = (BinaryResourcesHandler)this.config.getContext().getAttribute("net.jawr.web.resource.bundle.BINARY_CONTEXT_ATTRIBUTE")) != null) {
                JawrConfig binaryJawrConfig = binaryRsHandler.getConfig();
                String jawrWorkingDirectory = binaryJawrConfig.getJawrWorkingDirectory();
                if (binaryJawrConfig.getUseBundleMapping() && (jawrWorkingDirectory == null || !jawrWorkingDirectory.startsWith("/"))) {
                    Properties props = new Properties();
                    props.putAll(binaryRsHandler.getBinaryPathMap());
                    props.setProperty("jawr.config.hashcode", Integer.toString(binaryJawrConfig.getConfigProperties().hashCode()));
                    binaryRsHandler.getRsBundleHandler().storeJawrBundleMapping(props);
                }
            }
        }
    }

    private void executeGlobalPostProcessing(boolean processBundleFlag, StopWatch stopWatch) {
        if (this.resourceTypePostprocessor != null) {
            if (stopWatch != null) {
                stopWatch.start("Global postprocessing");
            }
            GlobalPostProcessingContext ctx = new GlobalPostProcessingContext(this.config, this, this.resourceHandler, processBundleFlag);
            this.resourceTypePostprocessor.processBundles(ctx, this.bundles);
            if (stopWatch != null) {
                stopWatch.stop();
            }
        }
    }

    private void joinAndStoreCompositeResourcebundle(CompositeResourceBundle composite) {
        this.stopProcessIfNeeded();
        BundleProcessingStatus status = new BundleProcessingStatus("file", composite, this.resourceHandler, this.config);
        Map<String, VariantSet> compositeBundleVariants = new HashMap<String, VariantSet>();
        for (JoinableResourceBundle childbundle : composite.getChildBundles()) {
            if (childbundle.getVariants() == null) continue;
            compositeBundleVariants = VariantUtils.concatVariants(compositeBundleVariants, childbundle.getVariants());
        }
        composite.setVariants(compositeBundleVariants);
        if (this.needToSearchForVariantInPostProcess || this.hasVariantPostProcessor(composite)) {
            status.setSearchingPostProcessorVariants(true);
            this.joinAndPostProcessBundle(composite, status);
            Map<String, VariantSet> postProcessVariants = status.getPostProcessVariants();
            if (!postProcessVariants.isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Post process variants found for bundle " + composite.getId() + ":" + postProcessVariants);
                }
                Map<String, VariantSet> newVariants = VariantUtils.concatVariants(composite.getVariants(), postProcessVariants);
                composite.setVariants(newVariants);
                status.setSearchingPostProcessorVariants(false);
                this.joinAndPostProcessBundle(composite, status);
            }
        } else {
            status.setSearchingPostProcessorVariants(false);
            this.joinAndPostProcessBundle(composite, status);
        }
    }

    private boolean hasVariantPostProcessor(JoinableResourceBundle bundle) {
        boolean hasVariantPostProcessor = false;
        ResourceBundlePostProcessor bundlePostProcessor = bundle.getBundlePostProcessor();
        if (bundlePostProcessor != null && ((AbstractChainedResourceBundlePostProcessor)bundlePostProcessor).isVariantPostProcessor()) {
            hasVariantPostProcessor = true;
        } else {
            bundlePostProcessor = bundle.getUnitaryPostProcessor();
            if (bundlePostProcessor != null && ((AbstractChainedResourceBundlePostProcessor)bundlePostProcessor).isVariantPostProcessor()) {
                hasVariantPostProcessor = true;
            }
        }
        return hasVariantPostProcessor;
    }

    private void joinAndPostProcessBundle(CompositeResourceBundle composite, BundleProcessingStatus status) {
        this.stopProcessIfNeeded();
        List<Map<String, String>> allVariants = VariantUtils.getAllVariants(composite.getVariants());
        allVariants.add(null);
        for (Map<String, String> variants : allVariants) {
            status.setBundleVariants(variants);
            JoinableResourceBundleContent store = new JoinableResourceBundleContent();
            for (JoinableResourceBundle childbundle : composite.getChildBundles()) {
                if (childbundle.getInclusionPattern().isIncludeOnlyOnDebug()) continue;
                JoinableResourceBundleContent childContent = this.joinAndPostprocessBundle(childbundle, variants, status);
                status.setProcessingType("file");
                StringBuffer content = this.executeUnitaryPostProcessing(composite, status, childContent.getContent(), this.unitaryCompositePostProcessor);
                childContent.setContent(content);
                store.append(childContent);
            }
            store = this.postProcessJoinedCompositeBundle(composite, store.getContent(), status);
            String variantKey = VariantUtils.getVariantKey(variants);
            String name = VariantUtils.getVariantBundleName(composite.getId(), variantKey, false);
            this.storeBundle(name, store);
            this.initBundleDataHashcode(composite, store, variantKey);
        }
    }

    private JoinableResourceBundleContent postProcessJoinedCompositeBundle(CompositeResourceBundle composite, StringBuffer content, BundleProcessingStatus status) {
        JoinableResourceBundleContent store = new JoinableResourceBundleContent();
        StringBuffer processedContent = null;
        status.setProcessingType("bundle");
        ResourceBundlePostProcessor bundlePostProcessor = composite.getBundlePostProcessor();
        processedContent = null != bundlePostProcessor ? bundlePostProcessor.postProcessBundle(status, content) : (null != this.compositePostProcessor ? this.compositePostProcessor.postProcessBundle(status, content) : content);
        store.setContent(processedContent);
        return store;
    }

    private void initBundleDataHashcode(JoinableResourceBundle bundle, JoinableResourceBundleContent store, String variant) {
        String bundleHashcode = this.bundleHashcodeGenerator.generateHashCode(this.config, store.getContent().toString());
        bundle.setBundleDataHashCode(variant, bundleHashcode);
    }

    @Override
    public BundleHashcodeType getBundleHashcodeType(String requestedPath) {
        BundleHashcodeType typeBundleHashcode = BundleHashcodeType.UNKNOW_BUNDLE;
        String[] pathInfos = PathNormalizer.extractBundleInfoFromPath(requestedPath, this.bundlePrefixes);
        if (pathInfos != null) {
            String bundlePrefix = pathInfos[0];
            String bundleId = pathInfos[1];
            String variantKey = pathInfos[2];
            String hashcode = pathInfos[3];
            JoinableResourceBundle bundle = this.resolveBundleForPath(bundleId);
            if (bundle != null) {
                String bundleHashcode = bundle.getBundleDataHashCode(variantKey);
                typeBundleHashcode = hashcode == null && bundleHashcode == null || hashcode != null && hashcode.equals(bundleHashcode) && (bundlePrefix == null && bundle.getBundlePrefix() == null || bundlePrefix != null && bundlePrefix.equals(bundle.getBundlePrefix())) ? BundleHashcodeType.VALID_HASHCODE : BundleHashcodeType.INVALID_HASHCODE;
            }
        }
        return typeBundleHashcode;
    }

    private void joinAndStoreBundle(JoinableResourceBundle bundle) {
        BundleProcessingStatus status = new BundleProcessingStatus("file", bundle, this.resourceHandler, this.config);
        JoinableResourceBundleContent store = null;
        if (this.needToSearchForVariantInPostProcess || this.hasVariantPostProcessor(bundle)) {
            status.setSearchingPostProcessorVariants(true);
            this.joinAndPostProcessBundle(bundle, status);
            status.setSearchingPostProcessorVariants(false);
            Map<String, VariantSet> postProcessVariants = status.getPostProcessVariants();
            if (!postProcessVariants.isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Post process variants found for bundle " + bundle.getId() + ":" + postProcessVariants);
                }
                Map<String, VariantSet> newVariants = VariantUtils.concatVariants(bundle.getVariants(), postProcessVariants);
                bundle.setVariants(newVariants);
                this.joinAndPostProcessBundle(bundle, status);
            }
        } else {
            status.setSearchingPostProcessorVariants(false);
            this.joinAndPostProcessBundle(bundle, status);
        }
        store = this.joinAndPostprocessBundle(bundle, null, status);
        this.storeBundle(bundle.getId(), store);
        this.initBundleDataHashcode(bundle, store, null);
    }

    private void storeBundle(String bundleId, JoinableResourceBundleContent store) {
        this.stopProcessIfNeeded();
        if (this.bundleMustBeProcessedInLive(store.getContent().toString())) {
            this.liveProcessBundles.add(bundleId);
        }
        this.resourceBundleHandler.storeBundle(bundleId, store);
    }

    private boolean bundleMustBeProcessedInLive(String content) {
        return content.contains("{JAWR_BUNDLE_PATH}");
    }

    private void joinAndPostProcessBundle(JoinableResourceBundle bundle, BundleProcessingStatus status) {
        List<Map<String, String>> allVariants = VariantUtils.getAllVariants(bundle.getVariants());
        allVariants.add(null);
        for (Map<String, String> variantMap : allVariants) {
            status.setBundleVariants(variantMap);
            String variantKey = VariantUtils.getVariantKey(variantMap);
            String name = VariantUtils.getVariantBundleName(bundle.getId(), variantKey, false);
            JoinableResourceBundleContent store = this.joinAndPostprocessBundle(bundle, variantMap, status);
            this.storeBundle(name, store);
            this.initBundleDataHashcode(bundle, store, variantKey);
        }
    }

    private JoinableResourceBundleContent joinAndPostprocessBundle(JoinableResourceBundle bundle, Map<String, String> variants, BundleProcessingStatus status) {
        JoinableResourceBundleContent bundleContent = new JoinableResourceBundleContent();
        StringBuffer bundleData = new StringBuffer();
        StringBuffer store = null;
        try {
            boolean firstPath = true;
            Iterator<BundlePath> pathIterator = null;
            pathIterator = bundle.getInclusionPattern().isIncludeOnlyOnDebug() ? bundle.getItemDebugPathList(variants).iterator() : bundle.getItemPathList(variants).iterator();
            Iterator<BundlePath> it = pathIterator;
            while (it.hasNext()) {
                StringWriter writer = new StringWriter();
                BufferedWriter bwriter = new BufferedWriter(writer);
                String path = it.next().getPath();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Adding file [" + path + "] to bundle " + bundle.getId());
                }
                Reader rd = null;
                try {
                    rd = this.resourceHandler.getResource(bundle, path, true);
                }
                catch (ResourceNotFoundException e) {
                    LOGGER.warn("A mapped resource was not found: [" + path + "]. Please check your configuration");
                    continue;
                }
                status.setLastPathAdded(path);
                rd = new UnicodeBOMReader(rd, this.config.getResourceCharset());
                if (!firstPath && ((UnicodeBOMReader)rd).hasBOM()) {
                    ((UnicodeBOMReader)rd).skipBOM();
                } else {
                    firstPath = false;
                }
                IOUtils.copy(rd, bwriter, true);
                StringBuffer buffer = writer.getBuffer();
                if (!buffer.toString().endsWith("\n")) {
                    buffer.append("\n");
                }
                status.setProcessingType("file");
                bundleData.append(this.executeUnitaryPostProcessing(bundle, status, buffer, this.unitaryPostProcessor));
            }
            store = this.executeBundlePostProcessing(bundle, status, bundleData);
        }
        catch (IOException e) {
            throw new BundlingProcessException("Unexpected IOException generating collected file [" + bundle.getId() + "].", e);
        }
        bundleContent.setContent(store);
        return bundleContent;
    }

    private StringBuffer executeUnitaryPostProcessing(JoinableResourceBundle bundle, BundleProcessingStatus status, StringBuffer content, ResourceBundlePostProcessor defaultPostProcessor) {
        StringBuffer bundleData = new StringBuffer();
        status.setProcessingType("file");
        if (null != bundle.getUnitaryPostProcessor()) {
            StringBuffer resourceData = bundle.getUnitaryPostProcessor().postProcessBundle(status, content);
            bundleData.append(resourceData);
        } else if (null != defaultPostProcessor) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("POSTPROCESSING UNIT:" + status.getLastPathAdded());
            }
            StringBuffer resourceData = defaultPostProcessor.postProcessBundle(status, content);
            bundleData.append(resourceData);
        } else {
            bundleData = content;
        }
        return bundleData;
    }

    private StringBuffer executeBundlePostProcessing(JoinableResourceBundle bundle, BundleProcessingStatus status, StringBuffer bundleData) {
        status.setProcessingType("bundle");
        status.setLastPathAdded(bundle.getId());
        StringBuffer store = null != bundle.getBundlePostProcessor() ? bundle.getBundlePostProcessor().postProcessBundle(status, bundleData) : (null != this.postProcessor ? this.postProcessor.postProcessBundle(status, bundleData) : bundleData);
        return store;
    }

    @Override
    public JoinableResourceBundle resolveBundleForPath(String path) {
        JoinableResourceBundle theBundle = null;
        for (JoinableResourceBundle bundle : this.bundles) {
            if (!bundle.getId().equals(path) && !bundle.belongsToBundle(path)) continue;
            theBundle = bundle;
            break;
        }
        return theBundle;
    }

    @Override
    public ClientSideHandlerGenerator getClientSideHandler() {
        return this.clientSideHandlerGenerator;
    }

    @Override
    public String getBundleTextDirPath() {
        return this.resourceBundleHandler.getBundleTextDirPath();
    }

    @Override
    public String getBundleZipDirPath() {
        return this.resourceBundleHandler.getBundleZipDirPath();
    }

    @Override
    public void notifyModification(List<JoinableResourceBundle> bundles) {
        for (JoinableResourceBundle bundle : bundles) {
            if (LOGGER.isInfoEnabled() && !bundle.isDirty()) {
                LOGGER.info("The bundle '" + bundle.getId() + "' has been modified and needs to be rebuild.");
            }
            bundle.setDirty(true);
            List<JoinableResourceBundle> linkedBundles = this.compositeResourceBundleMap.get(bundle.getId());
            if (linkedBundles == null) continue;
            for (JoinableResourceBundle compositeBundle : linkedBundles) {
                if (LOGGER.isInfoEnabled() && !compositeBundle.isDirty()) {
                    LOGGER.info("The composite bundle '" + compositeBundle.getId() + "', whose child has been modified, needs to be rebuild.");
                }
                compositeBundle.setDirty(true);
            }
        }
    }

    @Override
    public boolean bundlesNeedToBeRebuild() {
        return !this.getBundlesToRebuild().isEmpty();
    }

    @Override
    public List<String> getDirtyBundleNames() {
        ArrayList<String> bundleNames = new ArrayList<String>();
        List<JoinableResourceBundle> bundlesToRebuild = this.getBundlesToRebuild();
        for (JoinableResourceBundle bundle : bundlesToRebuild) {
            bundleNames.add(bundle.getName());
        }
        return bundleNames;
    }

    @Override
    public void setResourceWatcher(ResourceWatcher watcher) {
        this.watcher = watcher;
    }

    @Override
    public void setBundlingProcessLifeCycleListeners(List<BundlingProcessLifeCycleListener> listeners) {
        this.lifeCycleListeners.clear();
        this.lifeCycleListeners.addAll(listeners);
    }
}

