/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.iterator.AbstractPathsIterator;
import net.jawr.web.resource.bundle.iterator.BundlePath;
import net.jawr.web.resource.bundle.iterator.ConditionalCommentCallbackHandler;
import net.jawr.web.resource.bundle.iterator.ResourceBundlePathsIterator;
import net.jawr.web.util.StringUtils;

public class PathsIteratorImpl
extends AbstractPathsIterator
implements ResourceBundlePathsIterator {
    private final Iterator<JoinableResourceBundle> bundlesIterator;
    private JoinableResourceBundle currentBundle;

    public PathsIteratorImpl(List<JoinableResourceBundle> bundles, ConditionalCommentCallbackHandler commentCallbackHandler, Map<String, String> variants) {
        super(commentCallbackHandler, variants);
        List<JoinableResourceBundle> nonDebugOnlyBundles = this.filterBundlesToRender(bundles);
        this.bundlesIterator = nonDebugOnlyBundles.iterator();
    }

    protected List<JoinableResourceBundle> filterBundlesToRender(List<JoinableResourceBundle> bundles) {
        ArrayList<JoinableResourceBundle> filteredBundles = new ArrayList<JoinableResourceBundle>();
        for (JoinableResourceBundle bundle : bundles) {
            if (bundle.getInclusionPattern().isIncludeOnlyOnDebug()) continue;
            filteredBundles.add(bundle);
        }
        return filteredBundles;
    }

    public void addIterationEventListener(ConditionalCommentCallbackHandler listener) {
        this.commentCallbackHandler = listener;
    }

    @Override
    public BundlePath nextPath() {
        this.currentBundle = this.bundlesIterator.next();
        if (null != this.currentBundle.getExplorerConditionalExpression()) {
            this.commentCallbackHandler.openConditionalComment(this.currentBundle.getExplorerConditionalExpression());
        }
        String name = this.currentBundle.getId();
        BundlePath bundlePath = null;
        String productionURL = this.currentBundle.getAlternateProductionURL();
        bundlePath = StringUtils.isEmpty(productionURL) ? new BundlePath(this.currentBundle.getBundlePrefix(), PathNormalizer.joinPaths(this.currentBundle.getURLPrefix(this.variants), name), false) : new BundlePath(this.currentBundle.getBundlePrefix(), productionURL, true);
        return bundlePath;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.bundlesIterator.hasNext();
        if (null != this.currentBundle && null != this.currentBundle.getExplorerConditionalExpression()) {
            this.commentCallbackHandler.closeConditionalComment();
        }
        return hasNext;
    }
}

