/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.locale;

import javax.servlet.http.HttpServletRequest;
import net.jawr.web.resource.bundle.locale.LocaleResolver;
import net.jawr.web.resource.bundle.variant.VariantResolver;
import net.jawr.web.resource.bundle.variant.VariantSet;

public class LocaleVariantResolverWrapper
implements VariantResolver,
LocaleResolver {
    private final LocaleResolver localeResolver;

    public LocaleVariantResolverWrapper(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    @Override
    public String getVariantType() {
        return "locale";
    }

    @Override
    public String resolveVariant(HttpServletRequest request) {
        return this.localeResolver.resolveLocaleCode(request);
    }

    @Override
    public String resolveLocaleCode(HttpServletRequest request) {
        return this.localeResolver.resolveLocaleCode(request);
    }

    @Override
    public String getAvailableVariant(String variant, VariantSet variantSet) {
        String availableVariant = null;
        if (variantSet.contains(variant)) {
            availableVariant = variant;
        } else {
            String subVar = variant;
            while (subVar.indexOf(95) != -1) {
                if (!variantSet.contains(subVar = subVar.substring(0, subVar.lastIndexOf(95)))) continue;
                availableVariant = subVar;
            }
        }
        if (availableVariant == null) {
            availableVariant = variantSet.getDefaultVariant();
        }
        return availableVariant;
    }
}

