/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.locale;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import net.jawr.web.resource.bundle.IOUtils;

public class MessageBundleControl
extends ResourceBundle.Control {
    private boolean fallbackToSystemLocale = true;
    private final Charset charset;

    public MessageBundleControl(boolean fallbackToSystemLocale, Charset charset) {
        this.fallbackToSystemLocale = fallbackToSystemLocale;
        this.charset = charset;
    }

    @Override
    public Locale getFallbackLocale(String baseName, Locale locale) {
        if (baseName == null) {
            throw new NullPointerException();
        }
        Locale defaultLocale = Locale.getDefault();
        if (!this.fallbackToSystemLocale) {
            defaultLocale = new Locale("", "");
        }
        return locale.equals(defaultLocale) ? null : defaultLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        ResourceBundle bundle;
        block8: {
            block9: {
                String bundleName;
                block7: {
                    bundleName = this.toBundleName(baseName, locale);
                    bundle = null;
                    if (!format.equals("java.class")) break block7;
                    try {
                        Class<?> bundleClass = loader.loadClass(bundleName);
                        if (!ResourceBundle.class.isAssignableFrom(bundleClass)) {
                            throw new ClassCastException(bundleClass.getName() + " cannot be cast to ResourceBundle");
                        }
                        bundle = (ResourceBundle)bundleClass.newInstance();
                    }
                    catch (ClassNotFoundException e) {}
                    break block8;
                }
                if (!format.equals("java.properties")) break block9;
                final String resourceName = this.toResourceName(bundleName, "properties");
                final ClassLoader classLoader = loader;
                final boolean reloadFlag = reload;
                InputStream stream = null;
                InputStreamReader rd = null;
                try {
                    stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws IOException {
                            InputStream is = null;
                            if (reloadFlag) {
                                URLConnection connection;
                                URL url = classLoader.getResource(resourceName);
                                if (url != null && (connection = url.openConnection()) != null) {
                                    connection.setUseCaches(false);
                                    is = connection.getInputStream();
                                }
                            } else {
                                is = classLoader.getResourceAsStream(resourceName);
                            }
                            return is;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getException();
                }
                if (stream == null) break block8;
                try {
                    rd = new InputStreamReader(stream, this.charset);
                    bundle = new PropertyResourceBundle(rd);
                }
                catch (Throwable throwable) {
                    IOUtils.close(rd);
                    IOUtils.close(stream);
                    throw throwable;
                }
                IOUtils.close(rd);
                IOUtils.close(stream);
                break block8;
            }
            throw new IllegalArgumentException("unknown format: " + format);
        }
        return bundle;
    }

    @Override
    public long getTimeToLive(String baseName, Locale locale) {
        if (baseName == null || locale == null) {
            throw new NullPointerException();
        }
        return -1L;
    }

    public boolean isFallbackToSystemLocale() {
        return this.fallbackToSystemLocale;
    }

    public Locale getFallbackLocale() {
        Locale locale = null;
        locale = this.fallbackToSystemLocale ? Locale.getDefault() : new Locale("", "");
        return locale;
    }
}

