/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.locale;

import java.io.File;
import java.io.FileFilter;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.AbstractJavascriptGenerator;
import net.jawr.web.resource.bundle.generator.CachedGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.GeneratorMappingHelper;
import net.jawr.web.resource.bundle.generator.PathMappingProvider;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;
import net.jawr.web.resource.bundle.generator.variant.VariantResourceGenerator;
import net.jawr.web.resource.bundle.locale.LocaleUtils;
import net.jawr.web.resource.bundle.locale.MessageBundleControl;
import net.jawr.web.resource.bundle.locale.message.MessageBundleScriptCreator;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import net.jawr.web.resource.bundle.mappings.PathMapping;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.util.FileUtils;
import net.jawr.web.util.StringUtils;

@CachedGenerator(name="ResourceBundle Message", cacheDirectory="i18nMessages", mappingFileName="resourceBundleMessageMapping.txt")
public class ResourceBundleMessagesGenerator
extends AbstractJavascriptGenerator
implements VariantResourceGenerator,
PathMappingProvider {
    private static final String RESOURCE_BUNDLE_SEPARATOR = "\\|";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final String PROPERTIES_FILE_SUFFIX = ".properties";
    private static final String DEFAULT_RESOURCE_BUNDLE_CHARSET = "ISO-8859-1";
    private static final boolean DEFAULT_FALLBACK_TO_SYSTEM_LOCALE = true;
    private static final boolean DEFAULT_VALUE_ADD_QUOTE_TO_MSG_KEY = false;
    private final ResourceGeneratorResolver resolver;
    private final Map<String, List<String>> cachedAvailableLocalePerResource = new ConcurrentHashMap<String, List<String>>();
    protected MessageBundleControl control;

    public ResourceBundleMessagesGenerator() {
        this.resolver = ResourceGeneratorResolverFactory.createPrefixResolver("messages");
    }

    @Override
    public void beforeBundlingProcess() {
        super.beforeBundlingProcess();
        this.cachedAvailableLocalePerResource.clear();
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        boolean fallbackToSystemLocale = this.config.getBooleanProperty("jawr.locale.generator.fallbackToSystemLocale", true);
        String charsetName = this.config.getProperty("jawr.locale.generator.resourceBundle.charset", DEFAULT_RESOURCE_BUNDLE_CHARSET);
        Charset charset = Charset.forName(charsetName);
        this.control = new MessageBundleControl(fallbackToSystemLocale, charset);
    }

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    public Reader generateResource(String path, GeneratorContext context) {
        MessageBundleScriptCreator creator = new MessageBundleScriptCreator(context, this.control);
        this.addLinkedResources(path, context);
        return creator.createScript(context.getCharset());
    }

    protected void addLinkedResources(String path, GeneratorContext context) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Locale currentLocale = context.getLocale();
        if (currentLocale != null) {
            locales.add(currentLocale);
            if (StringUtils.isNotEmpty(currentLocale.getVariant())) {
                locales.add(new Locale(currentLocale.getCountry(), currentLocale.getLanguage()));
            }
            if (StringUtils.isNotEmpty(currentLocale.getLanguage())) {
                locales.add(new Locale(currentLocale.getCountry()));
            }
        }
        locales.add(this.control.getFallbackLocale());
        Locale baseLocale = new Locale("", "");
        if (!locales.contains(baseLocale)) {
            locales.add(baseLocale);
        }
        List<FilePathMapping> fMappings = this.getFileMappings(path, context, locales);
        this.addLinkedResources(path, context, fMappings);
    }

    protected List<FilePathMapping> getFileMappings(String path, GeneratorContext context, List<Locale> locales) {
        String[] names;
        ArrayList<FilePathMapping> fMappings = new ArrayList<FilePathMapping>();
        String fileSuffix = PROPERTIES_FILE_SUFFIX;
        for (String resourcePath : names = path.split(RESOURCE_BUNDLE_SEPARATOR)) {
            resourcePath = resourcePath.replace('.', '/');
            for (Locale locale : locales) {
                File f;
                String fileName;
                String resourceBundlePath = this.control.toBundleName(resourcePath, locale) + fileSuffix;
                URL rbURL = LocaleUtils.getResourceBundleURL(resourceBundlePath, context.getServletContext());
                if (rbURL == null || !StringUtils.isNotEmpty(fileName = (f = FileUtils.urlToFile(rbURL)).getAbsolutePath())) continue;
                long lastModified = this.rsHandler.getLastModified(fileName);
                FilePathMapping fMapping = new FilePathMapping(fileName, lastModified);
                fMappings.add(fMapping);
            }
        }
        return fMappings;
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.cacheProperties.put("jawr.locale.generator.fallbackToSystemLocale", Boolean.toString(this.config.getBooleanProperty("jawr.locale.generator.fallbackToSystemLocale", true)));
        this.cacheProperties.put("jawr.locale.generator.resourceBundle.charset", this.config.getProperty("jawr.locale.generator.resourceBundle.charset", DEFAULT_RESOURCE_BUNDLE_CHARSET));
        this.cacheProperties.put("jawr.locale.generator.quoteMsgKey", Boolean.toString(this.config.getBooleanProperty("jawr.locale.generator.quoteMsgKey", false)));
    }

    @Override
    protected boolean isCacheValid() {
        return super.isCacheValid() && StringUtils.equals(this.cacheProperties.getProperty("jawr.locale.generator.fallbackToSystemLocale"), this.config.getProperty("jawr.locale.generator.fallbackToSystemLocale", Boolean.toString(true))) && StringUtils.equals(this.cacheProperties.getProperty("jawr.locale.generator.resourceBundle.charset"), this.config.getProperty("jawr.locale.generator.resourceBundle.charset", DEFAULT_RESOURCE_BUNDLE_CHARSET)) && StringUtils.equals(this.cacheProperties.getProperty("jawr.locale.generator.quoteMsgKey"), this.config.getProperty("jawr.locale.generator.quoteMsgKey", Boolean.toString(false)));
    }

    @Override
    public String getDebugModeBuildTimeGenerationPath(String path) {
        String debugPath = path.replaceFirst(":", "/");
        if (debugPath.endsWith("@")) {
            debugPath = debugPath.replaceAll("@", "");
        } else {
            debugPath = debugPath.replaceAll("@", "_");
            debugPath = debugPath.replaceAll(RESOURCE_BUNDLE_SEPARATOR, "_");
        }
        return debugPath + "." + "js";
    }

    public List<String> getAvailableLocales(String resource) {
        return this.findAvailableLocales(resource);
    }

    protected List<String> findAvailableLocales(String resource) {
        List<String> availableLocales = this.cachedAvailableLocalePerResource.get(resource);
        if (availableLocales == null) {
            availableLocales = LocaleUtils.getAvailableLocaleSuffixesForBundle(resource);
            this.cachedAvailableLocalePerResource.put(resource, availableLocales);
        }
        return availableLocales;
    }

    @Override
    public Map<String, VariantSet> getAvailableVariants(String resource) {
        List<String> localeVariants = this.getAvailableLocales(resource);
        if (localeVariants.isEmpty()) {
            throw new BundlingProcessException("Enable to find the resource bundle : " + resource);
        }
        HashMap<String, VariantSet> variants = new HashMap<String, VariantSet>();
        VariantSet variantSet = new VariantSet("locale", "", localeVariants);
        variants.put("locale", variantSet);
        return variants;
    }

    @Override
    public List<PathMapping> getPathMappings(JoinableResourceBundle bundle, String resourcePath, ResourceReaderHandler rsReader) {
        String[] names;
        ArrayList<PathMapping> pathMappings = new ArrayList<PathMapping>();
        PathMapping pathMapping = null;
        GeneratorMappingHelper helper = new GeneratorMappingHelper(resourcePath);
        String path = this.resolver.getResourcePath(helper.getPath());
        for (String resourceName : names = path.split(RESOURCE_BUNDLE_SEPARATOR)) {
            String strURL;
            path = resourceName.replace('.', '/');
            URL rbURL = LocaleUtils.getResourceBundleURL(path = this.control.toBundleName(path, new Locale("", "")) + PROPERTIES_FILE_SUFFIX, this.config.getContext());
            if (rbURL == null || !(strURL = rbURL.toString()).startsWith("file:")) continue;
            String parentPath = "/WEB-INF/classes/" + PathNormalizer.getParentPath(path);
            String resourceBundleName = FileNameUtils.getBaseName(path);
            MessageBundleFileFilter filter = new MessageBundleFileFilter(resourceBundleName);
            pathMapping = new PathMapping(bundle, parentPath, filter);
            pathMappings.add(pathMapping);
        }
        return pathMappings;
    }

    private class MessageBundleFileFilter
    implements FileFilter {
        private final Pattern pattern;

        public MessageBundleFileFilter(String prefix) {
            String regex = "(.*)" + Pattern.quote(File.separator + prefix) + "(_[a-zA-Z]+){0,3}\\." + ResourceBundleMessagesGenerator.PROPERTIES_FILE_SUFFIX.substring(1);
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean accept(File f) {
            Matcher matcher = this.pattern.matcher(f.getAbsolutePath());
            return matcher.matches();
        }
    }
}

