/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.locale.message;

import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import net.jawr.web.resource.bundle.factory.util.PropertiesConfigHelper;
import net.jawr.web.resource.bundle.factory.util.RegexUtil;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.locale.MessageBundleControl;
import net.jawr.web.resource.bundle.locale.message.BundleStringJsonifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBundleScriptCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MessageBundleScriptCreator.class.getName());
    public static final String DEFAULT_NAMESPACE = "messages";
    private static final String SCRIPT_TEMPLATE = "/net/jawr/web/resource/bundle/message/messages.js";
    protected static StringBuffer template;
    protected String configParam;
    protected String namespace;
    private final String filter;
    protected Locale locale;
    protected List<String> filterList;
    protected ServletContext servletContext;
    private boolean addQuoteToMessageKey = false;
    protected MessageBundleControl control;

    public MessageBundleScriptCreator(GeneratorContext context, MessageBundleControl control) {
        this.servletContext = context.getServletContext();
        if (null == template) {
            template = this.loadScriptTemplate();
        }
        this.control = control;
        this.locale = context.getLocale();
        this.namespace = context.getParenthesesParam();
        this.namespace = null == this.namespace ? DEFAULT_NAMESPACE : this.namespace;
        this.filter = context.getBracketsParam();
        if (null != this.filter) {
            StringTokenizer tk = new StringTokenizer(this.filter, "\\|");
            this.filterList = new ArrayList<String>();
            while (tk.hasMoreTokens()) {
                this.filterList.add(tk.nextToken());
            }
        }
        this.configParam = context.getPath();
        Properties configProperties = context.getConfig().getConfigProperties();
        this.addQuoteToMessageKey = PropertiesConfigHelper.getBooleanValue(configProperties, "jawr.locale.generator.quoteMsgKey", false);
    }

    /*
     * Exception decompiling
     */
    private StringBuffer loadScriptTemplate() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Reader createScript(Charset charset) {
        String[] names = this.configParam.split("\\|");
        Properties props = new Properties();
        Locale currentLocale = this.getLocaleToApply();
        for (int x = 0; x < names.length; ++x) {
            ResourceBundle bundle;
            try {
                bundle = ResourceBundle.getBundle(names[x], currentLocale, this.control);
            }
            catch (MissingResourceException ex) {
                try {
                    bundle = ResourceBundle.getBundle(names[x], currentLocale, this.getClass().getClassLoader(), this.control);
                }
                catch (Exception e) {
                    bundle = ResourceBundle.getBundle(names[x], currentLocale, Thread.currentThread().getContextClassLoader(), this.control);
                }
            }
            this.updateProperties(bundle, props, charset);
        }
        return this.doCreateScript(props);
    }

    protected Locale getLocaleToApply() {
        Locale currentLocale = this.locale;
        if (currentLocale == null) {
            currentLocale = this.control.getFallbackLocale();
        }
        return currentLocale;
    }

    public Reader createScript(Charset charset, ResourceBundle bundle) {
        Properties props = new Properties();
        this.updateProperties(bundle, props, charset);
        return this.doCreateScript(props);
    }

    public void updateProperties(ResourceBundle bundle, Properties props, Charset charset) {
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!this.matchesFilter(key)) continue;
            String value = bundle.getString(key);
            props.put(key, value);
        }
    }

    protected Reader doCreateScript(Properties props) {
        BundleStringJsonifier bsj = new BundleStringJsonifier(props, this.addQuoteToMessageKey);
        String script = template.toString();
        String messages = bsj.serializeBundles().toString();
        script = script.replaceFirst("@namespace", RegexUtil.adaptReplacementToMatcher(this.namespace));
        script = script.replaceFirst("@messages", RegexUtil.adaptReplacementToMatcher(messages));
        return new StringReader(script);
    }

    protected boolean matchesFilter(String key) {
        boolean rets;
        boolean bl = rets = null == this.filterList;
        if (!rets) {
            Iterator<String> it = this.filterList.iterator();
            while (it.hasNext() && !rets) {
                rets = key.startsWith(it.next());
            }
        }
        return rets;
    }
}

