/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.mappings;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.iterator.BundlePath;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import net.jawr.web.resource.bundle.mappings.PathMapping;

public class BundlePathMapping {
    private final JoinableResourceBundle bundle;
    private final List<PathMapping> pathMappings;
    private List<BundlePath> itemPathList;
    private final List<FilePathMapping> filePathMappings;
    private List<FilePathMapping> linkedFilePathMappings;
    private List<BundlePath> itemDebugPathList;
    private Set<String> licensesPathList;

    public BundlePathMapping(JoinableResourceBundle bundle) {
        this.bundle = bundle;
        this.itemPathList = new CopyOnWriteArrayList<BundlePath>();
        this.itemDebugPathList = new CopyOnWriteArrayList<BundlePath>();
        this.licensesPathList = new HashSet<String>();
        this.pathMappings = new CopyOnWriteArrayList<PathMapping>();
        this.filePathMappings = new CopyOnWriteArrayList<FilePathMapping>();
        this.linkedFilePathMappings = new CopyOnWriteArrayList<FilePathMapping>();
    }

    public List<PathMapping> getPathMappings() {
        return this.pathMappings;
    }

    public void setPathMappings(List<String> pathMappings) {
        this.pathMappings.clear();
        if (pathMappings != null) {
            for (String mapping : pathMappings) {
                this.pathMappings.add(new PathMapping(this.bundle, mapping));
            }
        }
    }

    public List<BundlePath> getItemPathList() {
        return this.itemPathList;
    }

    public void setItemPathList(List<BundlePath> itemPathList) {
        this.itemPathList = itemPathList;
    }

    public List<BundlePath> getItemDebugPathList() {
        return this.itemDebugPathList;
    }

    public void setItemDebugPathList(List<BundlePath> itemDebugPathList) {
        this.itemDebugPathList = itemDebugPathList;
    }

    public Set<String> getLicensesPathList() {
        return this.licensesPathList;
    }

    public void setLicensesPathList(Set<String> licensesPathList) {
        this.licensesPathList = licensesPathList;
    }

    public List<FilePathMapping> getFilePathMappings() {
        return this.filePathMappings;
    }

    public List<FilePathMapping> getLinkedFilePathMappings() {
        return this.linkedFilePathMappings;
    }

    public void setLinkedFilePathMappings(List<FilePathMapping> mappings) {
        this.linkedFilePathMappings = mappings;
    }
}

