/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.mappings;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.iterator.BundlePath;
import net.jawr.web.resource.bundle.mappings.BundlePathMapping;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import net.jawr.web.resource.bundle.mappings.PathMapping;
import net.jawr.web.resource.bundle.sorting.SortFileParser;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.resource.bundle.variant.VariantUtils;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundlePathMappingBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundlePathMappingBuilder.class);
    public static final String LICENSES_FILENAME = ".license";
    public static final String SORT_FILE_NAME = ".sorting";
    protected JoinableResourceBundle bundle;
    protected GeneratorRegistry generatorRegistry;
    protected ResourceReaderHandler resourceReaderHandler;
    protected String fileExtension;
    private List<String> strPathMappings;

    public BundlePathMappingBuilder(JoinableResourceBundle bundle, String fileExtension, GeneratorRegistry generatorRegistry, ResourceReaderHandler rsHandler) {
        this.bundle = bundle;
        this.generatorRegistry = generatorRegistry;
        this.resourceReaderHandler = rsHandler;
        this.fileExtension = fileExtension != null && fileExtension.length() > 0 && fileExtension.charAt(0) != '.' ? "." + fileExtension : fileExtension;
    }

    public BundlePathMapping build(List<String> strPathMappings) {
        this.strPathMappings = strPathMappings;
        return this.build();
    }

    public BundlePathMapping build() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating bundle path List for " + this.bundle.getId());
        }
        BundlePathMapping bundlePathMapping = new BundlePathMapping(this.bundle);
        bundlePathMapping.setPathMappings(this.strPathMappings);
        List<PathMapping> pathMappings = bundlePathMapping.getPathMappings();
        Map<String, VariantSet> variants = new TreeMap<String, VariantSet>();
        if (pathMappings != null) {
            for (PathMapping pathMapping : pathMappings) {
                boolean isGeneratedPath = this.generatorRegistry.isPathGenerated(pathMapping.getPath());
                if (pathMapping.isDirectory()) {
                    this.addItemsFromDir(bundlePathMapping, pathMapping, false);
                } else if (pathMapping.isRecursive()) {
                    this.addItemsFromDir(bundlePathMapping, pathMapping, true);
                } else if (pathMapping.getPath().endsWith(this.fileExtension)) {
                    this.addPathMapping(bundlePathMapping, this.asPath(pathMapping.getPath(), isGeneratedPath));
                } else if (this.generatorRegistry.isPathGenerated(pathMapping.getPath())) {
                    this.addPathMapping(bundlePathMapping, pathMapping.getPath());
                } else if (pathMapping.getPath().endsWith(LICENSES_FILENAME)) {
                    bundlePathMapping.getLicensesPathList().add(this.asPath(pathMapping.getPath(), isGeneratedPath));
                } else {
                    throw new BundlingProcessException("Wrong mapping [" + pathMapping + "] for bundle [" + this.bundle.getName() + "]. Please check configuration. ");
                }
                if (!isGeneratedPath) continue;
                variants = VariantUtils.concatVariants(variants, this.generatorRegistry.getAvailableVariants(pathMapping.getPath()));
            }
        }
        this.bundle.setVariants(variants);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished creating bundle path List for " + this.bundle.getId());
        }
        return bundlePathMapping;
    }

    private void addPathMapping(BundlePathMapping bundlePathMapping, String pathMapping) {
        this.addFilePathMapping(bundlePathMapping, pathMapping);
        if (!this.bundle.getInclusionPattern().isIncludeOnlyOnDebug()) {
            bundlePathMapping.getItemPathList().add(new BundlePath(this.bundle.getBundlePrefix(), pathMapping));
        }
        if (!this.bundle.getInclusionPattern().isExcludeOnDebug()) {
            bundlePathMapping.getItemDebugPathList().add(new BundlePath(this.bundle.getBundlePrefix(), pathMapping));
        }
    }

    protected void addFilePathMapping(BundlePathMapping bundlePathMapping, String pathMapping) {
        long timestamp = 0L;
        String filePath = this.resourceReaderHandler.getFilePath(pathMapping);
        if (filePath != null) {
            timestamp = this.resourceReaderHandler.getLastModified(filePath);
            List<FilePathMapping> filePathMappings = bundlePathMapping.getFilePathMappings();
            boolean found = false;
            for (FilePathMapping filePathMapping : filePathMappings) {
                if (!filePathMapping.getPath().equals(filePath)) continue;
                found = true;
                break;
            }
            if (!found) {
                filePathMappings.add(new FilePathMapping(this.bundle, filePath, timestamp));
            }
        }
    }

    protected void addItemsFromDir(BundlePathMapping bundlePathMapping, PathMapping dirName, boolean addSubDirs) {
        Set<String> resources = this.resourceReaderHandler.getResourceNames(dirName.getPath());
        boolean isGeneratedPath = this.generatorRegistry.isPathGenerated(dirName.getPath());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding " + resources.size() + " resources from path [" + dirName.getPath() + "] to bundle " + this.bundle.getId());
        }
        if (resources.contains(SORT_FILE_NAME) || resources.contains("/.sorting")) {
            Reader reader;
            String sortFilePath = this.joinPaths(dirName.getPath(), SORT_FILE_NAME, isGeneratedPath);
            this.addFilePathMapping(bundlePathMapping, sortFilePath);
            try {
                reader = this.resourceReaderHandler.getResource(this.bundle, sortFilePath);
            }
            catch (ResourceNotFoundException e) {
                throw new BundlingProcessException("Unexpected ResourceNotFoundException when reading a sorting file[" + sortFilePath + "]", e);
            }
            SortFileParser parser = new SortFileParser(reader, resources, dirName.getPath());
            List<String> sortedResources = parser.getSortedResources();
            for (String resourceName : sortedResources) {
                if (resourceName.endsWith(this.fileExtension) || this.generatorRegistry.isPathGenerated(resourceName)) {
                    this.addPathMapping(bundlePathMapping, this.asPath(resourceName, isGeneratedPath));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Added to item path list from the sorting file:" + resourceName);
                    continue;
                }
                if (!dirName.isRecursive() || !this.resourceReaderHandler.isDirectory(resourceName)) continue;
                this.addItemsFromDir(bundlePathMapping, new PathMapping(this.bundle, resourceName + "/**"), true);
            }
        }
        if (resources.contains(LICENSES_FILENAME) || resources.contains("/.license")) {
            String licencePath = this.joinPaths(dirName.getPath(), LICENSES_FILENAME, isGeneratedPath);
            bundlePathMapping.getLicensesPathList().add(licencePath);
            this.addFilePathMapping(bundlePathMapping, licencePath);
        }
        ArrayList<String> folders = new ArrayList<String>();
        for (String resourceName : resources) {
            String resourcePath = this.joinPaths(dirName.getPath(), resourceName, isGeneratedPath);
            boolean resourceIsDir = this.resourceReaderHandler.isDirectory(resourcePath);
            if (addSubDirs && resourceIsDir) {
                folders.add(resourceName);
                continue;
            }
            if (!resourcePath.endsWith(this.fileExtension) && (!this.generatorRegistry.isPathGenerated(resourcePath) || resourceIsDir)) continue;
            this.addPathMapping(bundlePathMapping, this.asPath(resourcePath, isGeneratedPath));
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Added to item path list:" + this.asPath(resourcePath, isGeneratedPath));
        }
        if (addSubDirs) {
            Iterator it = folders.iterator();
            while (it.hasNext()) {
                String folderName = this.joinPaths(dirName.getPath(), (String)it.next(), isGeneratedPath);
                this.addItemsFromDir(bundlePathMapping, new PathMapping(this.bundle, folderName + "/**"), true);
            }
        }
    }

    private String asPath(String path, boolean generatedResource) {
        String result = path;
        if (!generatedResource) {
            result = PathNormalizer.asPath(path);
        }
        return result;
    }

    private String joinPaths(String dirName, String folderName, boolean generatedResource) {
        return PathNormalizer.joinPaths(dirName, folderName, generatedResource);
    }
}

