/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.mappings;

import java.util.List;
import java.util.Set;
import net.jawr.web.resource.bundle.CompositeResourceBundle;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.iterator.BundlePath;
import net.jawr.web.resource.bundle.mappings.BundlePathMapping;
import net.jawr.web.resource.bundle.mappings.BundlePathMappingBuilder;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;

public class CompositeBundlePathMappingBuilder
extends BundlePathMappingBuilder {
    public CompositeBundlePathMappingBuilder(CompositeResourceBundle bundle, String fileExtension, GeneratorRegistry generatorRegistry, ResourceReaderHandler rsHandler) {
        super(bundle, fileExtension, generatorRegistry, rsHandler);
    }

    @Override
    public BundlePathMapping build(List<String> strPathMappings) {
        BundlePathMapping bundlePathMapping = new BundlePathMapping(this.bundle);
        for (JoinableResourceBundle child : ((CompositeResourceBundle)this.bundle).getChildBundles()) {
            if (!child.getInclusionPattern().isIncludeOnlyOnDebug()) {
                bundlePathMapping.getItemPathList().addAll(child.getItemPathList());
                this.addFilePathMapping(bundlePathMapping, child.getItemPathList());
            }
            if (!child.getInclusionPattern().isExcludeOnDebug()) {
                bundlePathMapping.getItemDebugPathList().addAll(child.getItemDebugPathList());
                this.addFilePathMapping(bundlePathMapping, child.getItemDebugPathList());
            }
            bundlePathMapping.getLicensesPathList().addAll(child.getLicensesPathList());
            this.addFilePathMapping(bundlePathMapping, child.getLicensesPathList());
        }
        return bundlePathMapping;
    }

    private void addFilePathMapping(BundlePathMapping bundlePathMapping, Set<String> paths) {
        for (String path : paths) {
            this.addFilePathMapping(bundlePathMapping, path);
        }
    }

    private void addFilePathMapping(BundlePathMapping bundlePathMapping, List<BundlePath> itemPathList) {
        for (BundlePath bundlePath : itemPathList) {
            this.addFilePathMapping(bundlePathMapping, bundlePath.getPath());
        }
    }
}

