/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.mappings;

import java.io.File;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePathMappingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilePathMappingUtils.class);

    public static FilePathMapping buildFilePathMapping(String path, ResourceReaderHandler rsHandler) {
        return FilePathMappingUtils.buildFilePathMapping(null, path, rsHandler);
    }

    public static FilePathMapping buildFilePathMapping(JoinableResourceBundle bundle, String path, ResourceReaderHandler rsHandler) {
        FilePathMapping fPathMapping = null;
        String filePath = rsHandler.getFilePath(path);
        if (filePath != null) {
            File f = new File(filePath);
            if (f.exists()) {
                fPathMapping = new FilePathMapping(bundle, filePath, f.lastModified());
                if (bundle != null) {
                    bundle.getLinkedFilePathMappings().add(fPathMapping);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The file path '" + filePath + "'  associated to the URL '" + path + "' doesn't exixts.");
            }
        }
        return fPathMapping;
    }
}

