/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.mappings;

import java.io.File;
import java.io.FileFilter;
import net.jawr.web.resource.bundle.JoinableResourceBundle;

public class PathMapping {
    private static final String DIR_PATH_SUFFIX = "/";
    private static final String RECURSIVE_PATH_SUFFIX = "/**";
    protected final String mapping;
    protected final PathMappingKind kind;
    protected final JoinableResourceBundle bundle;
    protected final FileFilter fileFilter;

    public PathMapping(JoinableResourceBundle bundle, String mapping) {
        this(bundle, mapping, null);
    }

    public PathMapping(JoinableResourceBundle bundle, String mapping, FileFilter filter) {
        this.bundle = bundle;
        this.fileFilter = filter;
        if (mapping.endsWith(DIR_PATH_SUFFIX)) {
            this.mapping = mapping;
            this.kind = PathMappingKind.DIRECTORY;
        } else if (mapping.endsWith(RECURSIVE_PATH_SUFFIX)) {
            this.mapping = mapping.substring(0, mapping.length() - RECURSIVE_PATH_SUFFIX.length() + 1);
            this.kind = PathMappingKind.RECURSIVE_DIRECTORY;
        } else {
            this.mapping = mapping;
            this.kind = PathMappingKind.ASSET;
        }
    }

    public JoinableResourceBundle getBundle() {
        return this.bundle;
    }

    public String getPath() {
        return this.mapping;
    }

    public boolean hasFileFilter() {
        return this.fileFilter != null;
    }

    public boolean accept(String path) {
        if (this.fileFilter == null) {
            throw new UnsupportedOperationException("This method can't be called on a PahMapping which doesn't have a fileFilter");
        }
        File f = new File(path);
        return this.fileFilter.accept(f);
    }

    public boolean isAsset() {
        return this.kind == PathMappingKind.ASSET;
    }

    public boolean isDirectory() {
        return this.kind == PathMappingKind.DIRECTORY;
    }

    public boolean isRecursive() {
        return this.kind == PathMappingKind.RECURSIVE_DIRECTORY;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.mapping == null ? 0 : this.mapping.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathMapping other = (PathMapping)obj;
        if (this.kind != other.kind) {
            return false;
        }
        return !(this.mapping == null ? other.mapping != null : !this.mapping.equals(other.mapping));
    }

    protected static enum PathMappingKind {
        ASSET,
        DIRECTORY,
        RECURSIVE_DIRECTORY;

    }
}

