/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess;

import java.io.IOException;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import net.jawr.web.resource.bundle.postprocess.ChainedResourceBundlePostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChainedResourceBundlePostProcessor
implements ChainedResourceBundlePostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractChainedResourceBundlePostProcessor.class);
    protected ChainedResourceBundlePostProcessor nextProcessor;
    protected boolean isVariantPostProcessor = false;
    private final String id;

    public AbstractChainedResourceBundlePostProcessor(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        StringBuilder strId = new StringBuilder();
        strId.append(this.id);
        if (this.nextProcessor != null) {
            strId.append(",").append(this.nextProcessor.getId());
        }
        return strId.toString();
    }

    @Override
    public boolean isVariantPostProcessor() {
        return this.isVariantPostProcessor;
    }

    @Override
    public StringBuffer postProcessBundle(BundleProcessingStatus status, StringBuffer bundleData) {
        StringBuffer processedBundle = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("postprocessing bundle:" + status.getCurrentBundle().getId());
            }
            processedBundle = this.doPostProcessBundle(status, bundleData);
        }
        catch (IOException e) {
            throw new BundlingProcessException("Unexpected IOException during execution of a postprocessor.", e);
        }
        if (null != this.nextProcessor) {
            processedBundle = this.nextProcessor.postProcessBundle(status, processedBundle);
        }
        return processedBundle;
    }

    @Override
    public void addNextProcessor(ChainedResourceBundlePostProcessor nextProcessor) {
        if (!this.isVariantPostProcessor) {
            this.isVariantPostProcessor = nextProcessor.isVariantPostProcessor();
        }
        if (this.nextProcessor == null) {
            this.nextProcessor = nextProcessor;
        } else {
            this.nextProcessor.addNextProcessor(nextProcessor);
        }
    }

    protected abstract StringBuffer doPostProcessBundle(BundleProcessingStatus var1, StringBuffer var2) throws IOException;
}

