/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess;

import java.util.HashMap;
import java.util.Map;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.resource.bundle.variant.VariantUtils;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;

public class BundleProcessingStatus {
    public static final String FILE_PROCESSING_TYPE = "file";
    public static final String BUNDLE_PROCESSING_TYPE = "bundle";
    private final JoinableResourceBundle currentBundle;
    private final ResourceReaderHandler rsReader;
    private final JawrConfig jawrConfig;
    private String lastPathAdded;
    private boolean searchingPostProcessorVariants = true;
    private Map<String, String> bundleVariants = new HashMap<String, String>();
    private Map<String, VariantSet> postProcessVariants = new HashMap<String, VariantSet>();
    private Map<String, Object> dataMap = new HashMap<String, Object>();
    private String processingType;

    public BundleProcessingStatus(String processingType, JoinableResourceBundle currentBundle, ResourceReaderHandler rsHandler, JawrConfig jawrConfig) {
        this.processingType = processingType;
        this.currentBundle = currentBundle;
        this.rsReader = rsHandler;
        this.jawrConfig = jawrConfig;
    }

    public BundleProcessingStatus(BundleProcessingStatus status) {
        this.processingType = status.processingType;
        this.currentBundle = status.currentBundle;
        this.rsReader = status.rsReader;
        this.jawrConfig = status.jawrConfig;
        this.dataMap = status.dataMap;
        this.bundleVariants = status.bundleVariants;
        this.lastPathAdded = status.lastPathAdded;
        this.searchingPostProcessorVariants = status.searchingPostProcessorVariants;
    }

    public String getProcessingType() {
        return this.processingType;
    }

    public void setProcessingType(String processingType) {
        this.processingType = processingType;
    }

    public String getLastPathAdded() {
        return this.lastPathAdded;
    }

    public void setLastPathAdded(String lastPathAdded) {
        this.lastPathAdded = lastPathAdded;
    }

    public JoinableResourceBundle getCurrentBundle() {
        return this.currentBundle;
    }

    public ResourceReaderHandler getRsReader() {
        return this.rsReader;
    }

    public JawrConfig getJawrConfig() {
        return this.jawrConfig;
    }

    public boolean isSearchingPostProcessorVariants() {
        return this.searchingPostProcessorVariants;
    }

    public void setSearchingPostProcessorVariants(boolean searchingPostProcessorVariants) {
        this.searchingPostProcessorVariants = searchingPostProcessorVariants;
    }

    public Map<String, String> getBundleVariants() {
        return this.bundleVariants;
    }

    public void setBundleVariants(Map<String, String> bundleVariants) {
        this.bundleVariants = bundleVariants;
    }

    public String getVariant(String variantType) {
        String variant = null;
        if (this.bundleVariants != null) {
            variant = this.bundleVariants.get(variantType);
        }
        return variant;
    }

    public Map<String, VariantSet> getPostProcessVariants() {
        return this.postProcessVariants;
    }

    public void addPostProcessVariant(String variantType, VariantSet variantSet) {
        HashMap<String, VariantSet> variantMap = new HashMap<String, VariantSet>();
        variantMap.put(variantType, variantSet);
        this.addPostProcessVariant(variantMap);
    }

    public void addPostProcessVariant(Map<String, VariantSet> variants) {
        if (!this.searchingPostProcessorVariants) {
            throw new BundlingProcessException("You are not allowed to define post process variants if we are not searching for post processor variants.");
        }
        this.postProcessVariants = VariantUtils.concatVariants(this.postProcessVariants, variants);
    }

    public void putData(String key, Object value) {
        this.dataMap.put(key, value);
    }

    public Object getData(String key) {
        return this.dataMap.get(key);
    }
}

