/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.script.ScriptException;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.postprocess.AbstractChainedResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import net.jawr.web.util.StopWatch;
import net.jawr.web.util.js.JavascriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoPrefixerPostProcessor
extends AbstractChainedResourceBundlePostProcessor {
    private static final Logger PERF_LOGGER = LoggerFactory.getLogger((String)"net.jawr.perf.processing");
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoPrefixerPostProcessor.class);
    public static final String AUTOPREFIXER_SCRIPT_OPTIONS = "jawr.css.autoprefixer.options";
    public static final String AUTOPREFIXER_SCRIPT_LOCATION = "jawr.css.autoprefixer.script";
    public static final String AUTOPREFIXER_SCRIPT_DEFAULT_LOCATION = "/net/jawr/web/resource/bundle/postprocessor/css/autoprefixer/autoprefixer-6.4.0.js";
    public static final String AUTOPREFIXER_JS_ENGINE = "jawr.css.autoprefixer.js.engine";
    public static final String AUTOPREFIXER_DEFAULT_OPTIONS = "{}";
    private Object options;
    private JavascriptEngine jsEngine;

    public AutoPrefixerPostProcessor() {
        super("autoprefixer");
    }

    private void initialize(JawrConfig config) {
        StopWatch stopWatch = new StopWatch("Initializing JS engine for Autoprefixer");
        stopWatch.start();
        String script = config.getProperty(AUTOPREFIXER_SCRIPT_LOCATION, AUTOPREFIXER_SCRIPT_DEFAULT_LOCATION);
        String jsEngineName = config.getJavascriptEngineName(AUTOPREFIXER_JS_ENGINE);
        this.jsEngine = new JavascriptEngine(jsEngineName, true);
        this.jsEngine.getBindings().put("logger", (Object)LOGGER);
        try (InputStream inputStream = this.getResourceInputStream(config, script);){
            this.jsEngine.evaluate("autoprefixer.js", inputStream);
        }
        catch (IOException e) {
            throw new BundlingProcessException(e);
        }
        String strOptions = config.getProperty(AUTOPREFIXER_SCRIPT_OPTIONS, AUTOPREFIXER_DEFAULT_OPTIONS);
        this.options = this.jsEngine.execEval(strOptions);
        this.jsEngine.evaluate("initAutoPrefixer.js", String.format("if(logger.isDebugEnabled()){ logger.debug('Autoprefixer config : '+autoprefixer(%s).info());}", strOptions));
        this.jsEngine.evaluate("jawrAutoPrefixerProcess.js", "function process(cssSource, opts){\nvar result = autoprefixer.process.apply(autoprefixer, [cssSource, opts]);\nif(result.warnings){\nresult.warnings().forEach(function(message){\nif(logger.isWarnEnabled()){\nlogger.warn(message.toString());\n}\n});}\nreturn result.css;\n}");
        stopWatch.stop();
        if (PERF_LOGGER.isDebugEnabled()) {
            PERF_LOGGER.debug(stopWatch.shortSummary());
        }
    }

    private InputStream getResourceInputStream(JawrConfig config, String path) {
        InputStream is = config.getContext().getResourceAsStream(path);
        if (is == null) {
            try {
                is = ClassLoaderResourceUtils.getResourceAsStream(path, this);
            }
            catch (FileNotFoundException e) {
                throw new BundlingProcessException(e);
            }
        }
        return is;
    }

    @Override
    protected StringBuffer doPostProcessBundle(BundleProcessingStatus status, StringBuffer bundleData) throws IOException {
        if (this.jsEngine == null) {
            this.initialize(status.getJawrConfig());
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("Processing Autoprefixer on '" + status.getLastPathAdded() + "'");
        String cssSource = bundleData.toString();
        String res = null;
        try {
            res = (String)this.jsEngine.invokeFunction("process", cssSource, this.options);
        }
        catch (NoSuchMethodException | ScriptException e) {
            throw new BundlingProcessException(e);
        }
        stopWatch.stop();
        if (PERF_LOGGER.isDebugEnabled()) {
            PERF_LOGGER.debug(stopWatch.shortSummary());
        }
        return new StringBuffer(res);
    }
}

