/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess.impl;

import java.io.IOException;
import net.jawr.web.minification.CSSMinifier;
import net.jawr.web.resource.bundle.postprocess.AbstractChainedResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;

public class CSSMinPostProcessor
extends AbstractChainedResourceBundlePostProcessor {
    private static final String JAWR_CSS_POSTPROCESSOR_CSSMIN_KEEP_LICENCE = "jawr.css.postprocessor.cssmin.keepLicence";
    private CSSMinifier minifier;

    public CSSMinPostProcessor() {
        super("cssminify");
    }

    @Override
    protected StringBuffer doPostProcessBundle(BundleProcessingStatus status, StringBuffer bundleData) throws IOException {
        if (this.minifier == null) {
            boolean keepLicence = status.getJawrConfig().getBooleanProperty(JAWR_CSS_POSTPROCESSOR_CSSMIN_KEEP_LICENCE, false);
            this.minifier = new CSSMinifier(keepLicence);
        }
        try {
            return this.minifier.minifyCSS(bundleData);
        }
        catch (StackOverflowError e) {
            throw new Error("An error occured while processing the bundle '" + status.getCurrentBundle().getName() + "'", e);
        }
    }
}

