/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess.impl;

import java.io.IOException;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.postprocess.AbstractChainedResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import net.jawr.web.resource.bundle.postprocess.impl.PostProcessorCssImageUrlRewriter;

public class CSSURLPathRewriterPostProcessor
extends AbstractChainedResourceBundlePostProcessor {
    private static final String FAKE_BUNDLE_PREFIX = "/prefix/";

    public CSSURLPathRewriterPostProcessor() {
        super("csspathrewriter");
    }

    protected CSSURLPathRewriterPostProcessor(String id) {
        super(id);
    }

    @Override
    protected StringBuffer doPostProcessBundle(BundleProcessingStatus status, StringBuffer bundleData) throws IOException {
        String fullBundlePath = this.getFinalFullBundlePath(status);
        PostProcessorCssImageUrlRewriter urlRewriter = this.createImageUrlRewriter(status);
        return urlRewriter.rewriteUrl(status.getLastPathAdded(), fullBundlePath, bundleData.toString());
    }

    protected PostProcessorCssImageUrlRewriter createImageUrlRewriter(BundleProcessingStatus status) {
        return new PostProcessorCssImageUrlRewriter(status);
    }

    public String getFinalFullBundlePath(BundleProcessingStatus status) {
        JawrConfig jawrConfig = status.getJawrConfig();
        String bundleName = status.getCurrentBundle().getId();
        String bundlePrefix = this.getBundlePrefix(status, jawrConfig, bundleName);
        String fullBundlePath = PathNormalizer.concatWebPath(bundlePrefix, bundleName);
        return fullBundlePath;
    }

    protected String getBundlePrefix(BundleProcessingStatus status, JawrConfig jawrConfig, String bundleName) {
        String bundlePrefix = status.getCurrentBundle().getBundlePrefix();
        bundlePrefix = bundlePrefix == null ? "" : PathNormalizer.asPath(bundlePrefix);
        if (!bundleName.equals("/jawr_generator.css")) {
            bundlePrefix = bundlePrefix + FAKE_BUNDLE_PREFIX;
        }
        if (!"".equals(jawrConfig.getServletMapping())) {
            bundlePrefix = PathNormalizer.asPath(jawrConfig.getServletMapping() + bundlePrefix) + "/";
        }
        return bundlePrefix;
    }
}

