/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess.impl;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jawr.web.resource.bundle.postprocess.AbstractChainedResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssCharsetFilterPostProcessor
extends AbstractChainedResourceBundlePostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CssCharsetFilterPostProcessor.class);
    private static final String CHARSET_DECLARATION_SUFFIX = "\";";
    private static final String CHARSET_DECLARATION_PREFIX = "@charset \"";
    private static final Pattern CHARSET_DECLARATION = Pattern.compile("@charset \"(.+)\";");

    public CssCharsetFilterPostProcessor() {
        super("csscharset");
    }

    @Override
    protected StringBuffer doPostProcessBundle(BundleProcessingStatus status, StringBuffer bundleData) throws IOException {
        Matcher matcher = CHARSET_DECLARATION.matcher(bundleData.toString());
        StringBuffer sb = new StringBuffer();
        String currentCharset = null;
        boolean charsetDefinedAtBegining = false;
        while (matcher.find()) {
            if (matcher.start() == 0) {
                currentCharset = matcher.group(1);
                charsetDefinedAtBegining = true;
                continue;
            }
            if (currentCharset != null) {
                if (!currentCharset.equalsIgnoreCase(matcher.group(1))) {
                    LOGGER.warn("The bundle '" + status.getCurrentBundle().getId() + "' contains CSS with different charset declaration.");
                }
            } else {
                currentCharset = matcher.group(1);
                LOGGER.warn("For the bundle '" + status.getCurrentBundle().getId() + "', the charset declaration is not defined at the top. The charset which will be set is '" + currentCharset + "'.");
            }
            matcher.appendReplacement(sb, "");
        }
        matcher.appendTail(sb);
        if (currentCharset != null && !charsetDefinedAtBegining) {
            sb = new StringBuffer(CHARSET_DECLARATION_PREFIX + currentCharset + CHARSET_DECLARATION_SUFFIX + "\n" + sb.toString());
        }
        return sb;
    }
}

