/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.BinaryResourcesHandler;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.bundle.CheckSumUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.css.CssImageUrlRewriter;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.mappings.FilePathMappingUtils;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import net.jawr.web.servlet.util.MIMETypesSupport;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessorCssImageUrlRewriter
extends CssImageUrlRewriter {
    private static Logger LOGGER = LoggerFactory.getLogger(PostProcessorCssImageUrlRewriter.class);
    private Map<String, String> binaryMapping;
    private JoinableResourceBundle bundle;

    public PostProcessorCssImageUrlRewriter(BundleProcessingStatus status) {
        this(status.getJawrConfig(), status.getCurrentBundle(), (Map)status.getData("jawrBinaryMapping"));
        if (status.getData("jawrBinaryMapping") == null) {
            status.putData("jawrBinaryMapping", this.binaryMapping);
        }
    }

    public PostProcessorCssImageUrlRewriter(JawrConfig config, JoinableResourceBundle bundle) {
        this(config, bundle, new HashMap<String, String>());
    }

    public PostProcessorCssImageUrlRewriter(JawrConfig config, JoinableResourceBundle bundle, Map<String, String> binaryMappping) {
        super(config);
        this.bundle = bundle;
        this.binaryMapping = binaryMappping;
        if (this.binaryMapping == null) {
            this.binaryMapping = new HashMap<String, String>();
        }
    }

    @Override
    protected String getRewrittenImagePath(String originalCssPath, String newCssPath, String url) throws IOException {
        String imgUrl = null;
        String currentCss = originalCssPath;
        boolean generatedImg = false;
        if (this.binaryRsHandler != null) {
            GeneratorRegistry imgRsGeneratorRegistry = this.binaryRsHandler.getConfig().getGeneratorRegistry();
            generatedImg = imgRsGeneratorRegistry.isGeneratedBinaryResource(url);
        }
        boolean cssGeneratorIsHandleCssImage = this.isCssGeneratorHandlingCssImage(currentCss);
        String rootPath = currentCss;
        if (generatedImg || cssGeneratorIsHandleCssImage) {
            String tempUrl = url;
            if (cssGeneratorIsHandleCssImage && !generatedImg) {
                tempUrl = PathNormalizer.concatWebPath(rootPath, url);
            }
            imgUrl = this.rewriteURL(tempUrl, this.binaryServletPath, newCssPath, this.binaryRsHandler);
        } else {
            if (this.config.getGeneratorRegistry().isPathGenerated(rootPath)) {
                rootPath = rootPath.substring(rootPath.indexOf(":") + 1);
            }
            imgUrl = PathNormalizer.concatWebPath(rootPath, url);
            imgUrl = this.rewriteURL(imgUrl, this.binaryServletPath, newCssPath, this.binaryRsHandler);
        }
        if (imgUrl == null) {
            LOGGER.error("The CSS image path for '" + url + "' defined in '" + currentCss + "' is out of the application context. Please check your CSS file.");
        }
        return imgUrl;
    }

    private boolean isCssGeneratorHandlingCssImage(String currentCss) {
        return this.config.getGeneratorRegistry().isHandlingCssImage(currentCss);
    }

    protected String rewriteURL(String url, String binaryServletPath, String newCssPath, BinaryResourcesHandler binaryRsHandler) throws IOException {
        String imgUrl = url;
        if (this.isBinaryResource(imgUrl)) {
            imgUrl = this.addCacheBuster(url, binaryRsHandler);
            if (StringUtils.isNotEmpty(binaryServletPath)) {
                imgUrl = binaryServletPath + "/" + imgUrl;
            }
        }
        imgUrl = PathNormalizer.asPath(imgUrl);
        return PathNormalizer.getRelativeWebPath(PathNormalizer.getParentPath(newCssPath), imgUrl);
    }

    protected boolean isBinaryResource(String resourcePath) {
        String extension = FileNameUtils.getExtension(resourcePath);
        if (extension != null) {
            extension = extension.toLowerCase();
        }
        return MIMETypesSupport.getSupportedProperties(this).containsKey(extension);
    }

    private String addCacheBuster(String url, BinaryResourcesHandler binaryRsHandler) throws IOException {
        if (binaryRsHandler != null) {
            FilePathMappingUtils.buildFilePathMapping(this.bundle, url, binaryRsHandler.getRsReaderHandler());
        }
        String newUrl = null;
        if (this.binaryMapping != null && (newUrl = this.binaryMapping.get(url)) != null) {
            return newUrl;
        }
        if (binaryRsHandler != null) {
            newUrl = binaryRsHandler.getCacheUrl(url);
            if (newUrl != null) {
                return newUrl;
            }
            try {
                newUrl = CheckSumUtils.getCacheBustedUrl(url, binaryRsHandler.getRsReaderHandler(), binaryRsHandler.getConfig());
            }
            catch (ResourceNotFoundException e) {
                LOGGER.info("Impossible to define the checksum for the resource '" + url + "'. ");
                return url;
            }
            catch (IOException e) {
                LOGGER.info("Impossible to define the checksum for the resource '" + url + "'.");
                return url;
            }
            binaryRsHandler.addMapping(url, newUrl);
        } else {
            newUrl = url;
        }
        this.binaryMapping.put(url, newUrl);
        return newUrl;
    }
}

