/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess.impl.css.base64;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import net.jawr.web.resource.bundle.postprocess.ResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.postprocess.impl.CSSURLPathRewriterPostProcessor;
import net.jawr.web.resource.bundle.postprocess.impl.PostProcessorCssImageUrlRewriter;
import net.jawr.web.resource.bundle.postprocess.impl.css.base64.Base64EncodedResource;
import net.jawr.web.resource.bundle.postprocess.impl.css.base64.Base64PostProcessorCssImageUrlRewriter;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64ImageEncoderPostProcessor
extends CSSURLPathRewriterPostProcessor
implements ResourceBundlePostProcessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Base64ImageEncoderPostProcessor.class);
    protected static final String TAB = "\t";
    protected static final String BOUNDARY_SEPARATOR = "JAWR_BASE64_ENCODED_IMAGES";
    protected static final String PROPERTY_URL_VALUE_START = "url(";
    protected static final String PROPERTY_URL_VALUE_END = ")";
    protected static final String BOUNDARY_SEPARATOR_PREFIX = "--";
    protected static final String MHTML_PREFIX = "mhtml:";

    public Base64ImageEncoderPostProcessor() {
        super("base64ImageEncoder");
        this.isVariantPostProcessor = true;
    }

    @Override
    protected PostProcessorCssImageUrlRewriter createImageUrlRewriter(BundleProcessingStatus status) {
        return new Base64PostProcessorCssImageUrlRewriter(status);
    }

    @Override
    protected StringBuffer doPostProcessBundle(BundleProcessingStatus status, StringBuffer bundleData) throws IOException {
        String browser;
        Map<String, String> bundleVariants;
        HashMap<String, Base64EncodedResource> encodedResources;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Base64 encoding resources - '" + status.getLastPathAdded() + "'");
        }
        if ((encodedResources = (HashMap<String, Base64EncodedResource>)status.getData("BASE64_ENCODED_RESOURCES")) == null) {
            encodedResources = new HashMap<String, Base64EncodedResource>();
            status.putData("BASE64_ENCODED_RESOURCES", encodedResources);
        }
        StringBuffer sb = bundleData;
        if (status.getProcessingType().equals("file")) {
            sb = super.doPostProcessBundle(status, bundleData);
        }
        if (!encodedResources.isEmpty() && status.isSearchingPostProcessorVariants()) {
            VariantSet variantSet = new VariantSet("browser", "", new String[]{"", "ie6", "ie7"});
            status.addPostProcessVariant("browser", variantSet);
            variantSet = new VariantSet("connectionType", "", new String[]{"", "ssl"});
            status.addPostProcessVariant("connectionType", variantSet);
        }
        if (!status.isSearchingPostProcessorVariants() && status.getProcessingType().equals("bundle") && (bundleVariants = status.getBundleVariants()) != null && StringUtils.isNotEmpty(browser = bundleVariants.get("browser")) && ("ie6".equals(browser) || "ie7".equals(browser))) {
            this.prependBase64EncodedResources(sb, encodedResources);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Base64 Postprocessing done");
        }
        return sb;
    }

    protected void prependBase64EncodedResources(StringBuffer sb, Map<String, Base64EncodedResource> encodedImages) {
        Iterator<Map.Entry<String, Base64EncodedResource>> it = encodedImages.entrySet().iterator();
        StringBuilder mhtml = new StringBuilder();
        String lineSeparator = "\n";
        mhtml.append("/*!").append(lineSeparator);
        mhtml.append("Content-Type: multipart/related; boundary=\"JAWR_BASE64_ENCODED_IMAGES\"").append(lineSeparator).append(lineSeparator);
        while (it.hasNext()) {
            Map.Entry<String, Base64EncodedResource> pair = it.next();
            Base64EncodedResource encodedResource = pair.getValue();
            mhtml.append("--JAWR_BASE64_ENCODED_IMAGES").append(lineSeparator);
            mhtml.append("Content-Type:").append(encodedResource.getType()).append(lineSeparator);
            mhtml.append("Content-Location:").append(encodedResource.getId()).append(lineSeparator);
            mhtml.append("Content-Transfer-Encoding:base64").append(lineSeparator).append(lineSeparator);
            mhtml.append(encodedResource.getBase64Encoding()).append(lineSeparator).append(lineSeparator);
        }
        mhtml.append("--JAWR_BASE64_ENCODED_IMAGES--").append(lineSeparator);
        mhtml.append("*/").append(lineSeparator).append(lineSeparator);
        sb.insert(0, mhtml.toString());
    }
}

