/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.postprocess.impl.js.uglify;

import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.script.ScriptException;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.minification.CompressionResult;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.util.StopWatch;
import net.jawr.web.util.StringUtils;
import net.jawr.web.util.js.JavascriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UglifyJS {
    private static final Logger PERF_LOGGER = LoggerFactory.getLogger((String)"net.jawr.perf.processing");
    private static final String[] UGLIFY_SCRIPTS = new String[]{"utils.js", "ast.js", "parse.js", "transform.js", "scope.js", "output.js", "compress.js", "sourcemap.js", "uglify.js"};
    boolean baseEngine = true;
    private final JavascriptEngine jsEngine;
    private final JawrConfig config;
    private final Object options;

    public UglifyJS(JawrConfig config, String scriptDirLocation, String optionsInJson) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("initializing JS engine for Uglify");
        String jsEngineName = config.getJavascriptEngineName("jawr.js.postprocessor.uglify.js.engine");
        this.jsEngine = new JavascriptEngine(jsEngineName);
        this.config = config;
        this.options = this.jsEngine.execEval(optionsInJson);
        String baseJsLocation = StringUtils.isNotEmpty(scriptDirLocation) ? scriptDirLocation : "/net/jawr/web/resource/bundle/postprocessor/js/uglify/";
        for (String script : UGLIFY_SCRIPTS) {
            this.jsEngine.evaluate(script, this.getResourceInputStream(baseJsLocation + script));
        }
        stopWatch.stop();
        if (PERF_LOGGER.isDebugEnabled()) {
            PERF_LOGGER.debug(stopWatch.prettyPrint());
        }
    }

    private InputStream getResourceInputStream(String path) {
        InputStream is = this.config.getContext().getResourceAsStream(path);
        if (is == null) {
            try {
                is = ClassLoaderResourceUtils.getResourceAsStream(path, this);
            }
            catch (FileNotFoundException e) {
                throw new BundlingProcessException(e);
            }
        }
        return is;
    }

    public CompressionResult compress(String scriptSource) {
        Object result = null;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("Compressing using Uglify");
        try {
            result = this.jsEngine.invokeFunction("minify", scriptSource, this.options);
        }
        catch (NoSuchMethodException | ScriptException e) {
            throw new BundlingProcessException(e);
        }
        stopWatch.stop();
        if (PERF_LOGGER.isDebugEnabled()) {
            PERF_LOGGER.debug(stopWatch.prettyPrint());
        }
        return (CompressionResult)result;
    }
}

