/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.renderer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.servlet.RendererRequestUtils;

public class BundleRendererContext {
    private String contextPath;
    private Map<String, String> variants = new HashMap<String, String>();
    private Set<String> includedBundles;
    private Set<String> includedResources;
    private boolean globalBundleAdded;
    private boolean useGzip;
    private boolean isSslRequest;
    private HttpServletRequest request;

    public BundleRendererContext(String contextPath, Map<String, String> variants, boolean useGzip, boolean isSslRequest) {
        this.contextPath = contextPath;
        this.variants = variants;
        this.includedBundles = new HashSet<String>();
        this.includedResources = new HashSet<String>();
        this.useGzip = useGzip;
        this.isSslRequest = isSslRequest;
    }

    public BundleRendererContext(HttpServletRequest request, JawrConfig jawrConfig) {
        this.request = request;
        this.contextPath = request.getContextPath();
        this.variants = jawrConfig.getGeneratorRegistry().resolveVariants(request);
        this.useGzip = RendererRequestUtils.isRequestGzippable(request, jawrConfig);
        this.isSslRequest = RendererRequestUtils.isSslRequest(request);
        this.includedBundles = new HashSet<String>();
        this.includedResources = new HashSet<String>();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Map<String, String> getVariants() {
        return this.variants;
    }

    public void setVariants(Map<String, String> variants) {
        this.variants = variants;
    }

    public boolean isGlobalBundleAdded() {
        return this.globalBundleAdded;
    }

    public void setGlobalBundleAdded(boolean globalBundleAdded) {
        this.globalBundleAdded = globalBundleAdded;
    }

    public boolean isUseGzip() {
        return this.useGzip;
    }

    public void setUseGzip(boolean useGzip) {
        this.useGzip = useGzip;
    }

    public boolean isSslRequest() {
        return this.isSslRequest;
    }

    public void setSslRequest(boolean isSslRequest) {
        this.isSslRequest = isSslRequest;
    }

    public Set<String> getIncludedBundles() {
        return this.includedBundles;
    }

    public void setIncludedBundles(Set<String> includedBundles) {
        this.includedBundles = includedBundles;
    }

    public Set<String> getIncludedResources() {
        return this.includedResources;
    }

    public void setIncludedResources(Set<String> includedResources) {
        this.includedResources = includedResources;
    }
}

