/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.renderer;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.jawr.web.DebugMode;
import net.jawr.web.exception.JawrLinkRenderingException;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.iterator.BundlePath;
import net.jawr.web.resource.bundle.iterator.ConditionalCommentCallbackHandler;
import net.jawr.web.resource.bundle.iterator.ResourceBundlePathsIterator;
import net.jawr.web.resource.bundle.renderer.AbstractBundleLinkRenderer;
import net.jawr.web.resource.bundle.renderer.BundleRendererContext;
import net.jawr.web.resource.bundle.renderer.ConditionalCommentRenderer;
import net.jawr.web.resource.bundle.renderer.CssBundleLinkRenderer;
import net.jawr.web.resource.bundle.variant.VariantUtils;
import net.jawr.web.servlet.RendererRequestUtils;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSSHTMLBundleLinkRenderer
extends AbstractBundleLinkRenderer
implements CssBundleLinkRenderer {
    private static final long serialVersionUID = 8478334123266702133L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSHTMLBundleLinkRenderer.class);
    private static final String PRE_TAG = "<link rel=\"stylesheet\" type=\"text/css\" media=\"";
    private static final String PRE_TAG_ALTERNATE = "<link rel=\"alternate stylesheet\" type=\"text/css\" media=\"";
    private static final String TITLE_PREFIX_TAG = "\" title=\"";
    private static final String MID_TAG = "\" href=\"";
    private static final String POST_TAG = "\" />\n";
    private static final String POST_HTML_TAG = "\" >\n";
    private static final String POST_XHTML_EXT_TAG = "\" ></link>\n";
    public static final String FLAVORS_XHTML = "xhtml";
    public static final String FLAVORS_XHTML_EXTENDED = "xhtml_ext";
    public static final String FLAVORS_HTML = "html";
    private static String closingFlavor = "\" />\n";
    private String media;
    private boolean alternate;
    private boolean displayAlternateStyles;
    private String title;

    @Override
    public void init(ResourceBundlesHandler bundler, Boolean useRandomParam, String media, boolean alternate, boolean displayAlternateStyles, String title) {
        this.init(bundler, useRandomParam);
        this.media = null == media ? "screen" : media;
        this.displayAlternateStyles = displayAlternateStyles;
        this.alternate = alternate;
        this.title = title;
        if (displayAlternateStyles && alternate) {
            throw new IllegalArgumentException("You can't use the displayAlternateStyle and alternate properties together.");
        }
        if (displayAlternateStyles && StringUtils.isNotEmpty(title)) {
            this.title = null;
            LOGGER.warn("As you are using the displayAlternateStyle property, the title value will be overrided.");
        }
    }

    public static void setClosingTag(String flavor) {
        closingFlavor = FLAVORS_XHTML_EXTENDED.equalsIgnoreCase(flavor) ? POST_XHTML_EXT_TAG : (FLAVORS_HTML.equalsIgnoreCase(flavor) ? POST_HTML_TAG : POST_TAG);
    }

    @Override
    public String getResourceType() {
        return "css";
    }

    private boolean isForcedToRenderIeCssBundleInDebug(BundleRendererContext ctx, boolean debugOn) {
        return debugOn && this.getResourceType().equals("css") && this.bundler.getConfig().isForceCssBundleInDebugForIEOn() && RendererRequestUtils.isIE(ctx.getRequest());
    }

    @Override
    protected void performGlobalBundleLinksRendering(BundleRendererContext ctx, Writer out, boolean debugOn) throws IOException {
        if (this.isForcedToRenderIeCssBundleInDebug(ctx, debugOn)) {
            ResourceBundlePathsIterator resourceBundleIterator = this.bundler.getGlobalResourceBundlePaths(DebugMode.FORCE_NON_DEBUG_IN_IE, (ConditionalCommentCallbackHandler)new ConditionalCommentRenderer(out), ctx.getVariants());
            while (resourceBundleIterator.hasNext()) {
                BundlePath globalBundlePath = resourceBundleIterator.nextPath();
                this.renderIeCssBundleLink(ctx, out, globalBundlePath);
            }
        } else {
            super.performGlobalBundleLinksRendering(ctx, out, debugOn);
        }
    }

    @Override
    protected void renderBundleLinks(JoinableResourceBundle bundle, BundleRendererContext ctx, Map<String, String> variant, Writer out, boolean debugOn) throws IOException {
        if (this.alternate && StringUtils.isNotEmpty(this.title)) {
            Map<String, String> variants = ctx.getVariants();
            variants.put("skin", this.title);
        }
        if (this.isForcedToRenderIeCssBundleInDebug(ctx, debugOn)) {
            ResourceBundlePathsIterator it = this.bundler.getBundlePaths(DebugMode.FORCE_NON_DEBUG_IN_IE, bundle.getId(), new ConditionalCommentRenderer(out), variant);
            while (it.hasNext()) {
                BundlePath bundlePath = it.nextPath();
                this.renderIeCssBundleLink(ctx, out, bundlePath);
            }
        } else {
            super.renderBundleLinks(bundle, ctx, variant, out, debugOn);
        }
    }

    @Override
    protected void renderBundleLinks(JoinableResourceBundle bundle, String requestedPath, BundleRendererContext ctx, Writer out, boolean debugOn, boolean renderDependencyLinks) throws IOException {
        boolean bundleAlreadyIncluded = ctx.getIncludedBundles().contains(bundle.getId());
        super.renderBundleLinks(bundle, requestedPath, ctx, out, debugOn, renderDependencyLinks);
        if (!bundleAlreadyIncluded && this.displayAlternateStyles) {
            if (debugOn) {
                this.addComment("Start adding members resolved by '" + requestedPath + "'. Bundle id is: '" + bundle.getId() + "'", out);
            }
            List<Map<String, String>> variants = VariantUtils.getAllVariants(bundle.getVariants());
            Map<String, String> currentVariant = this.bundler.getConfig().getGeneratorRegistry().getAvailableVariantMap(bundle.getVariants(), ctx.getVariants());
            String currentLocale = currentVariant.get("locale");
            variants.remove(currentVariant);
            this.alternate = true;
            for (Map<String, String> variant : variants) {
                if (variant == null) continue;
                String skin = variant.get("skin");
                if (skin == null) {
                    throw new JawrLinkRenderingException("You are trying to render alternate CSS for a bundle which don't have skin variant defined.");
                }
                String locale = variant.get("locale");
                if (currentLocale != null && !currentLocale.equals(locale)) continue;
                this.title = skin;
                this.renderBundleLinks(bundle, ctx, variant, out, debugOn);
            }
            this.alternate = false;
        }
    }

    @Override
    protected String renderLink(String fullPath) {
        StringBuilder sb = new StringBuilder();
        if (this.alternate) {
            sb.append(PRE_TAG_ALTERNATE);
        } else {
            sb.append(PRE_TAG);
        }
        sb.append(this.media);
        if (StringUtils.isNotEmpty(this.title)) {
            sb.append(TITLE_PREFIX_TAG).append(this.title);
        }
        sb.append(MID_TAG).append(fullPath).append(closingFlavor);
        return sb.toString();
    }

    private void renderIeCssBundleLink(BundleRendererContext ctx, Writer out, BundlePath bundlePath) throws IOException {
        Random randomSeed = new Random();
        int random = randomSeed.nextInt();
        if (random < 0) {
            random *= -1;
        }
        String path = "ieCssGen:" + bundlePath.getPath();
        path = PathNormalizer.createGenerationPath(path, this.bundler.getConfig().getGeneratorRegistry(), "d=" + random);
        out.write(this.createBundleLink(path, null, null, ctx.getContextPath(), ctx.isSslRequest()));
    }
}

