/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.renderer;

import java.io.IOException;
import java.io.Writer;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.renderer.AbstractBundleLinkRenderer;
import net.jawr.web.resource.bundle.renderer.BundleRendererContext;
import net.jawr.web.resource.bundle.renderer.JsBundleLinkRenderer;
import net.jawr.web.util.StringUtils;

public class JavascriptHTMLBundleLinkRenderer
extends AbstractBundleLinkRenderer
implements JsBundleLinkRenderer {
    private static final long serialVersionUID = -7753927288041046690L;
    private static final String PRE_TAG = "<script type=\"";
    private static final String TYPE_END_ATTRIBUTE = "\" ";
    private static final String DEFAULT_TYPE = "text/javascript";
    private static final String SRC_START_ATTRIBUTE = "src=\"";
    private static final String SRC_END_ATTRIBUTE = "\"";
    private static final String ASYNC_ATTRIBUTE = " async=\"async\"";
    private static final String DEFER_ATTRIBUTE = " defer=\"defer\"";
    private static final String POST_TAG = " ></script>\n";
    private String type;
    private boolean defer;
    private boolean async;
    private String crossorigin;
    private boolean renderGlobalLinks;

    @Override
    public void init(ResourceBundlesHandler bundler, Boolean useRandomParam, Boolean async, Boolean defer, String crossorigin) {
        this.init(bundler, DEFAULT_TYPE, useRandomParam, async, defer, crossorigin);
    }

    @Override
    public void init(ResourceBundlesHandler bundler, String type, Boolean useRandomParam, Boolean async, Boolean defer, String crossorigin) {
        this.init(bundler, useRandomParam);
        if (async != null) {
            this.async = async;
        }
        if (defer != null) {
            this.defer = defer;
        }
        this.crossorigin = crossorigin;
        this.type = StringUtils.isEmpty(type) ? DEFAULT_TYPE : type;
    }

    @Override
    public String getResourceType() {
        return "js";
    }

    @Override
    protected void performGlobalBundleLinksRendering(BundleRendererContext ctx, Writer out, boolean debugOn) throws IOException {
        this.renderGlobalLinks = true;
        super.performGlobalBundleLinksRendering(ctx, out, debugOn);
        this.renderGlobalLinks = false;
    }

    @Override
    protected String renderLink(String fullPath) {
        StringBuffer sb = new StringBuffer(PRE_TAG).append(this.type).append(TYPE_END_ATTRIBUTE).append(SRC_START_ATTRIBUTE);
        sb.append(fullPath);
        sb.append(SRC_END_ATTRIBUTE);
        if (this.async && !this.renderGlobalLinks) {
            sb.append(ASYNC_ATTRIBUTE);
        }
        if (this.defer && !this.renderGlobalLinks) {
            sb.append(DEFER_ATTRIBUTE);
        }
        if (this.crossorigin != null && !this.renderGlobalLinks) {
            sb.append(' ').append("crossorigin").append("=\"").append(this.crossorigin).append(SRC_END_ATTRIBUTE);
        }
        sb.append(POST_TAG);
        return sb.toString();
    }
}

