/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.variant.resolver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.jawr.web.resource.bundle.variant.VariantResolver;
import net.jawr.web.resource.bundle.variant.VariantSet;

public class BrowserResolver
implements VariantResolver {
    private static final Pattern IE_PATTERN = Pattern.compile("MSIE (\\d+)");

    @Override
    public String getVariantType() {
        return "browser";
    }

    @Override
    public String getAvailableVariant(String variant, VariantSet variantSet) {
        String browser = variantSet.getDefaultVariant();
        if (variantSet.contains(variant)) {
            browser = variant;
        }
        return browser;
    }

    @Override
    public String resolveVariant(HttpServletRequest request) {
        String browser = null;
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null) {
            Matcher matcher = IE_PATTERN.matcher(userAgent);
            if (matcher.find()) {
                browser = "ie" + matcher.group(1);
            } else if (userAgent.contains("AppleWebKit")) {
                browser = "webkit";
            } else if (userAgent.contains("Firefox")) {
                browser = "firefox";
            } else if (userAgent.contains("Opera")) {
                browser = "opera";
            }
        }
        return browser;
    }
}

