/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.handler.reader;

import java.util.Comparator;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.resource.bundle.generator.ResourceGenerator;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.global.preprocessor.css.smartsprites.CssSmartSpritesResourceReader;
import net.jawr.web.resource.handler.reader.FileSystemResourceReader;
import net.jawr.web.resource.handler.reader.ResourceReader;
import net.jawr.web.resource.handler.reader.ServletContextResourceReader;

public class ResourceReaderComparator
implements Comparator<ResourceReader> {
    private final boolean baseDirHighPriority;

    public ResourceReaderComparator(JawrConfig config) {
        this.baseDirHighPriority = Boolean.valueOf(config.getProperty("jawr.basecontext.directory.high.priority"));
    }

    @Override
    public int compare(ResourceReader o1, ResourceReader o2) {
        return this.getPriority(o1) - this.getPriority(o2);
    }

    private int getPriority(ResourceReader o1) {
        int priority = 0;
        if (o1 instanceof ServletContextResourceReader) {
            priority = this.baseDirHighPriority ? 5 : 4;
        } else if (o1 instanceof FileSystemResourceReader) {
            priority = this.baseDirHighPriority ? 4 : 5;
        } else if (o1 instanceof CssSmartSpritesResourceReader) {
            priority = 1;
        } else if (o1 instanceof ResourceGenerator) {
            priority = ((ResourceGenerator)((Object)o1)).getResolver().getType().equals((Object)ResourceGeneratorResolver.ResolverType.PREFIXED) ? 3 : 2;
        }
        return priority;
    }
}

