/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.handler.reader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import net.jawr.web.JawrConstant;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.context.ThreadLocalJawrContext;
import net.jawr.web.exception.InterruptBundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.generator.ResourceGenerator;
import net.jawr.web.resource.handler.reader.FileSystemResourceReader;
import net.jawr.web.resource.handler.reader.ResourceBrowser;
import net.jawr.web.resource.handler.reader.ResourceReader;
import net.jawr.web.resource.handler.reader.ResourceReaderComparator;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.resource.handler.reader.ServletContextAware;
import net.jawr.web.resource.handler.reader.ServletContextResourceReader;
import net.jawr.web.resource.handler.reader.StreamResourceReader;
import net.jawr.web.resource.handler.reader.TextResourceReader;
import net.jawr.web.resource.handler.reader.WorkingDirectoryLocationAware;
import net.jawr.web.servlet.util.MIMETypesSupport;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContextResourceReaderHandler
implements ResourceReaderHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletContextResourceReaderHandler.class);
    private final JawrConfig config;
    private ServletContext servletContext;
    private String workingDirectory;
    private GeneratorRegistry generatorRegistry;
    private final List<TextResourceReader> resourceReaders = new ArrayList<TextResourceReader>();
    private final List<StreamResourceReader> streamResourceReaders = new ArrayList<StreamResourceReader>();
    private final List<ResourceBrowser> resourceInfoProviders = new ArrayList<ResourceBrowser>();
    private final List<String> allowedExtensions = new ArrayList<String>();

    public ServletContextResourceReaderHandler(ServletContext servletContext, JawrConfig jawrConfig, GeneratorRegistry generatorRegistry) throws IOException {
        String tempWorkingDirectory = ((File)servletContext.getAttribute("javax.servlet.context.tempdir")).getCanonicalPath();
        this.config = jawrConfig;
        if (this.config.getUseBundleMapping() && StringUtils.isNotEmpty(this.config.getJawrWorkingDirectory())) {
            tempWorkingDirectory = this.config.getJawrWorkingDirectory();
        }
        if (tempWorkingDirectory == null) {
            throw new IllegalStateException("There is no temporary directory configured for this web application.\nThe servlet context attribute 'javax.servlet.context.tempdir' should contain the temporary directory attribute.");
        }
        this.servletContext = servletContext;
        this.generatorRegistry = generatorRegistry;
        this.generatorRegistry.setResourceReaderHandler(this);
        if (tempWorkingDirectory.startsWith("file://")) {
            tempWorkingDirectory = tempWorkingDirectory.substring("file://".length());
        }
        this.workingDirectory = tempWorkingDirectory + File.separator + "jawrTmp";
        this.allowedExtensions.addAll(JawrConstant.DEFAULT_RESOURCE_EXTENSIONS);
        if ("binary".equals(this.config.getResourceType())) {
            for (Object key : MIMETypesSupport.getSupportedProperties(JawrConfig.class).keySet()) {
                if (this.allowedExtensions.contains((String)key)) continue;
                this.allowedExtensions.add((String)key);
            }
        } else {
            this.allowedExtensions.add(this.config.getResourceType());
        }
        ServletContextResourceReader rd = (ServletContextResourceReader)ClassLoaderResourceUtils.buildObjectInstance(this.config.getServletContextResourceReaderClass());
        rd.init(servletContext, jawrConfig);
        this.addResourceReader(rd);
        String baseContextDir = this.config.getProperty("jawr.basecontext.directory");
        if (StringUtils.isNotEmpty(baseContextDir)) {
            FileSystemResourceReader fileRd = new FileSystemResourceReader(jawrConfig);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The base directory context is set to " + baseContextDir);
            }
            this.addResourceReader(fileRd);
            boolean baseContextDirHighPriority = Boolean.valueOf(this.config.getProperty("jawr.basecontext.directory.high.priority"));
            if (LOGGER.isDebugEnabled()) {
                if (baseContextDirHighPriority) {
                    LOGGER.debug("Jawr will search in priority in the base directory context before searching in the war content.");
                } else {
                    LOGGER.debug("Jawr will search in priority in the war content before searching in the base directory context.");
                }
            }
        }
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setWorkingDirectory(String workingDir) {
        this.workingDirectory = workingDir;
    }

    private void initReader(Object obj) {
        if (obj instanceof WorkingDirectoryLocationAware) {
            ((WorkingDirectoryLocationAware)obj).setWorkingDirectory(this.workingDirectory);
        }
        if (obj instanceof ServletContextAware) {
            ((ServletContextAware)obj).setServletContext(this.servletContext);
        }
        if (obj instanceof ResourceBrowser) {
            this.resourceInfoProviders.add(0, (ResourceBrowser)obj);
        }
    }

    @Override
    public void addResourceReader(ResourceReader rd) {
        if (rd instanceof TextResourceReader) {
            this.resourceReaders.add((TextResourceReader)rd);
            Collections.sort(this.resourceReaders, new ResourceReaderComparator(this.config));
        }
        if (rd instanceof StreamResourceReader) {
            this.streamResourceReaders.add((StreamResourceReader)rd);
            Collections.sort(this.streamResourceReaders, new ResourceReaderComparator(this.config));
        }
        this.initReader(rd);
    }

    @Override
    public Reader getResource(String resourceName) throws ResourceNotFoundException {
        return this.getResource(null, resourceName, false);
    }

    @Override
    public Reader getResource(JoinableResourceBundle bundle, String resourceName) throws ResourceNotFoundException {
        return this.getResource(bundle, resourceName, false);
    }

    @Override
    public Reader getResource(JoinableResourceBundle bundle, String resourceName, boolean processingBundle) throws ResourceNotFoundException {
        return this.getResource(bundle, resourceName, processingBundle, new ArrayList());
    }

    @Override
    public Reader getResource(JoinableResourceBundle bundle, String resourceName, boolean processingBundle, List<Class<?>> excludedReader) throws ResourceNotFoundException {
        if (ThreadLocalJawrContext.isInterruptingProcessingBundle()) {
            throw new InterruptBundlingProcessException();
        }
        Reader rd = null;
        String resourceExtension = FileNameUtils.getExtension(resourceName);
        boolean generatedPath = this.generatorRegistry.isPathGenerated(resourceName);
        if (generatedPath || this.allowedExtensions.contains(resourceExtension.toLowerCase())) {
            ArrayList<TextResourceReader> list = new ArrayList<TextResourceReader>();
            list.addAll(this.resourceReaders);
            for (TextResourceReader rsReader : list) {
                block8: {
                    if (this.isInstanceOf(rsReader, excludedReader) || rsReader instanceof ResourceGenerator && !((ResourceGenerator)((Object)rsReader)).getResolver().matchPath(resourceName)) continue;
                    try {
                        rd = rsReader.getResource(bundle, resourceName, processingBundle);
                    }
                    catch (Exception e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("An exception occured while trying to read resource '" + resourceName + "'. Continuing with other readers. Error : ", (Throwable)e);
                        }
                        if (!LOGGER.isInfoEnabled()) break block8;
                        LOGGER.info("An exception occured while trying to read resource '" + resourceName + "'. Continuing with other readers. Error : " + e.getMessage());
                    }
                }
                if (rd == null) continue;
                break;
            }
        } else {
            LOGGER.warn("The resource '" + resourceName + "' will not be read as its extension is not an allowed one.");
        }
        if (rd == null) {
            throw new ResourceNotFoundException(resourceName);
        }
        return rd;
    }

    private boolean isInstanceOf(Object rd, List<Class<?>> interfaces) {
        boolean result = false;
        for (Class<?> class1 : interfaces) {
            if (!class1.isInstance(rd)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public InputStream getResourceAsStream(String resourceName) throws ResourceNotFoundException {
        return this.getResourceAsStream(resourceName, false);
    }

    @Override
    public InputStream getResourceAsStream(String resourceName, boolean processingBundle) throws ResourceNotFoundException {
        if (ThreadLocalJawrContext.isInterruptingProcessingBundle()) {
            throw new InterruptBundlingProcessException();
        }
        this.generatorRegistry.loadGeneratorIfNeeded(resourceName);
        InputStream is = null;
        String resourceExtension = FileNameUtils.getExtension(resourceName);
        boolean generatedPath = this.generatorRegistry.isPathGenerated(resourceName);
        if (generatedPath || this.allowedExtensions.contains(resourceExtension.toLowerCase())) {
            ArrayList<StreamResourceReader> list = new ArrayList<StreamResourceReader>();
            list.addAll(this.streamResourceReaders);
            for (StreamResourceReader rsReader : list) {
                block8: {
                    if (rsReader instanceof ResourceGenerator && !((ResourceGenerator)((Object)rsReader)).getResolver().matchPath(resourceName)) continue;
                    try {
                        is = rsReader.getResourceAsStream(resourceName);
                    }
                    catch (Exception e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("An exception occured while trying to read resource '" + resourceName + "'. Continuing with other readers. Error : ", (Throwable)e);
                        }
                        if (!LOGGER.isInfoEnabled()) break block8;
                        LOGGER.info("An exception occured while trying to read resource '" + resourceName + "'. Continuing with other readers. Error : " + e.getMessage());
                    }
                }
                if (is == null) continue;
                break;
            }
        } else {
            LOGGER.warn("The resource '" + resourceName + "' will not be read as its extension is not an allowed one.");
        }
        if (is == null) {
            throw new ResourceNotFoundException(resourceName);
        }
        return is;
    }

    @Override
    public Set<String> getResourceNames(String dirName) {
        TreeSet<String> resourceNames = new TreeSet<String>();
        ArrayList<ResourceBrowser> list = new ArrayList<ResourceBrowser>();
        list.addAll(this.resourceInfoProviders);
        for (ResourceBrowser rsBrowser : list) {
            if (this.generatorRegistry.isPathGenerated(dirName)) {
                ResourceGenerator rsGeneratorBrowser;
                if (!(rsBrowser instanceof ResourceGenerator) || !(rsGeneratorBrowser = (ResourceGenerator)((Object)rsBrowser)).getResolver().matchPath(dirName)) continue;
                resourceNames.addAll(rsBrowser.getResourceNames(dirName));
                break;
            }
            if (rsBrowser instanceof ResourceGenerator) continue;
            resourceNames.addAll(rsBrowser.getResourceNames(dirName));
            break;
        }
        return resourceNames;
    }

    @Override
    public boolean isDirectory(String resourceName) {
        boolean result = false;
        ArrayList<ResourceBrowser> list = new ArrayList<ResourceBrowser>();
        list.addAll(this.resourceInfoProviders);
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !result) {
            ResourceBrowser rsBrowser = (ResourceBrowser)iterator.next();
            if (this.generatorRegistry.isPathGenerated(resourceName)) {
                ResourceGenerator rsGeneratorBrowser;
                if (!(rsBrowser instanceof ResourceGenerator) || !(rsGeneratorBrowser = (ResourceGenerator)((Object)rsBrowser)).getResolver().matchPath(resourceName)) continue;
                result = rsBrowser.isDirectory(resourceName);
                continue;
            }
            if (rsBrowser instanceof ResourceGenerator) continue;
            result = rsBrowser.isDirectory(resourceName);
        }
        return result;
    }

    @Override
    public String getFilePath(String resourcePath) {
        String filePath = null;
        ArrayList<ResourceBrowser> list = new ArrayList<ResourceBrowser>();
        list.addAll(this.resourceInfoProviders);
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && filePath == null) {
            ResourceBrowser rsBrowser = (ResourceBrowser)iterator.next();
            if (this.generatorRegistry.isPathGenerated(resourcePath)) {
                ResourceGenerator rsGeneratorBrowser;
                if (!(rsBrowser instanceof ResourceGenerator) || !(rsGeneratorBrowser = (ResourceGenerator)((Object)rsBrowser)).getResolver().matchPath(resourcePath)) continue;
                filePath = rsBrowser.getFilePath(resourcePath);
                continue;
            }
            if (rsBrowser instanceof ResourceGenerator) continue;
            filePath = rsBrowser.getFilePath(resourcePath);
        }
        return filePath;
    }

    @Override
    public long getLastModified(String filePath) {
        long lastModified = 0L;
        File f = new File(filePath);
        if (f.exists()) {
            lastModified = f.lastModified();
        }
        return lastModified;
    }
}

