/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.watcher;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.mappings.PathMapping;
import net.jawr.web.resource.watcher.JawrWatchEvent;
import net.jawr.web.resource.watcher.ResourceWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JawrWatchEventProcessor
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(JawrWatchEventProcessor.class);
    private final AtomicBoolean stopProcessing = new AtomicBoolean(false);
    private ResourceWatcher watcher;
    private ResourceBundlesHandler bundlesHandler;
    private final BlockingQueue<JawrWatchEvent> watchEvents;
    private final AtomicLong lastProcessTime = new AtomicLong();

    public JawrWatchEventProcessor(ResourceWatcher watcher, BlockingQueue<JawrWatchEvent> watchEvents) {
        super(watcher.getBundlesHandler().getResourceType() + " JawrWatchEventProcessor ");
        this.watcher = watcher;
        this.bundlesHandler = watcher.getBundlesHandler();
        this.watchEvents = watchEvents;
    }

    public void stopProcessing() {
        this.stopProcessing.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopProcessing.get()) {
            try {
                AtomicBoolean processingBundle;
                JawrWatchEvent evt = this.watchEvents.take();
                AtomicBoolean atomicBoolean = processingBundle = this.bundlesHandler.isProcessingBundle();
                synchronized (atomicBoolean) {
                    while (processingBundle.get() && !this.stopProcessing.get()) {
                        try {
                            processingBundle.wait();
                        }
                        catch (InterruptedException e) {
                            LOGGER.debug("Thread interrupted");
                        }
                    }
                }
                if (evt == null || this.stopProcessing.get()) continue;
                this.process(evt);
            }
            catch (InterruptedException e) {
                LOGGER.debug("Thread interrupted");
            }
        }
        this.bundlesHandler = null;
        this.watcher = null;
    }

    public void process(JawrWatchEvent evt) {
        block11: {
            Path resolvedPath = evt.getResolvedPath();
            List<PathMapping> mappings = this.watcher.getPathToResourceBundle().get(evt.getDirPath());
            if (mappings != null) {
                boolean isDir = Files.isDirectory(resolvedPath, LinkOption.NOFOLLOW_LINKS);
                ArrayList<JoinableResourceBundle> bundles = new ArrayList<JoinableResourceBundle>();
                ArrayList<PathMapping> recursivePathMappings = new ArrayList<PathMapping>();
                for (PathMapping mapping : mappings) {
                    String filePath = resolvedPath.toFile().getAbsolutePath();
                    if (mapping.isAsset()) {
                        String fileName = FileNameUtils.getName(filePath);
                        if (!fileName.equals(FileNameUtils.getName(mapping.getPath()))) continue;
                        bundles.add(mapping.getBundle());
                        continue;
                    }
                    if (isDir) {
                        if (mapping.isRecursive() && (!mapping.hasFileFilter() || mapping.accept(filePath))) {
                            bundles.add(mapping.getBundle());
                        }
                    } else if (!mapping.hasFileFilter() || mapping.accept(filePath)) {
                        bundles.add(mapping.getBundle());
                    }
                    if (!mapping.isRecursive()) continue;
                    recursivePathMappings.add(mapping);
                }
                if (!bundles.isEmpty()) {
                    this.bundlesHandler.notifyModification(bundles);
                }
                if (!recursivePathMappings.isEmpty() && evt.getKind() == StandardWatchEventKinds.ENTRY_CREATE && isDir) {
                    try {
                        this.watcher.registerAll(resolvedPath, recursivePathMappings);
                    }
                    catch (IOException e) {
                        if (!LOGGER.isWarnEnabled()) break block11;
                        LOGGER.warn(e.getMessage());
                    }
                }
            }
        }
        this.lastProcessTime.set(Calendar.getInstance().getTimeInMillis());
    }

    public boolean hasNoEventToProcess() {
        long currentTime = Calendar.getInstance().getTimeInMillis();
        return this.watchEvents.isEmpty() && currentTime - this.lastProcessTime.get() > (long)this.bundlesHandler.getConfig().getSmartBundlingDelayAfterLastEvent();
    }
}

