/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.watcher;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import net.jawr.web.resource.bundle.mappings.PathMapping;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.resource.watcher.JawrWatchEvent;
import net.jawr.web.resource.watcher.JawrWatchEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceWatcher
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceWatcher.class);
    private final WatchService watchService;
    private ResourceBundlesHandler bundlesHandler;
    private ResourceReaderHandler rsReader;
    private final Map<WatchKey, Path> keys;
    private AtomicBoolean stopWatching = new AtomicBoolean(false);
    private final Map<Path, List<PathMapping>> pathToResourceBundle = new ConcurrentHashMap<Path, List<PathMapping>>();
    private final JawrWatchEventProcessor jawrEvtProcessor;
    private BlockingQueue<JawrWatchEvent> watchEvents = new LinkedBlockingQueue<JawrWatchEvent>();

    public ResourceWatcher(ResourceBundlesHandler bundlesHandler, ResourceReaderHandler rsReader) {
        super(bundlesHandler.getResourceType() + " JawrResourceWatcher");
        this.bundlesHandler = bundlesHandler;
        this.rsReader = rsReader;
        this.keys = new HashMap<WatchKey, Path>();
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new BundlingProcessException(e);
        }
        this.jawrEvtProcessor = new JawrWatchEventProcessor(this, this.watchEvents);
        this.jawrEvtProcessor.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                ResourceWatcher.this.close();
            }
        }));
    }

    public ResourceBundlesHandler getBundlesHandler() {
        return this.bundlesHandler;
    }

    public Map<Path, List<PathMapping>> getPathToResourceBundle() {
        return this.pathToResourceBundle;
    }

    public void stopWatching() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Stopping resource watching");
        }
        this.stopWatching.set(true);
        this.jawrEvtProcessor.stopProcessing();
        this.jawrEvtProcessor.interrupt();
    }

    public synchronized void initPathToResourceBundleMap(List<JoinableResourceBundle> bundles) throws IOException {
        for (JoinableResourceBundle bundle : bundles) {
            this.removePathMappingFromPathMap(bundle);
            List<PathMapping> mappings = bundle.getMappings();
            for (PathMapping pathMapping : mappings) {
                this.register(pathMapping);
            }
            List<FilePathMapping> fMappings = bundle.getLinkedFilePathMappings();
            for (FilePathMapping fMapping : fMappings) {
                this.register(fMapping);
            }
        }
    }

    private void register(PathMapping pathMapping) throws IOException {
        GeneratorRegistry generatorRegistry = this.bundlesHandler.getConfig().getGeneratorRegistry();
        ArrayList<PathMapping> mappings = new ArrayList<PathMapping>();
        if (generatorRegistry.isPathGenerated(pathMapping.getPath())) {
            List<PathMapping> genPathMappings = generatorRegistry.getGeneratedPathMappings(pathMapping.getBundle(), pathMapping.getPath(), this.rsReader);
            if (genPathMappings != null) {
                mappings.addAll(genPathMappings);
            } else {
                mappings.add(pathMapping);
            }
        } else {
            mappings.add(pathMapping);
        }
        for (PathMapping pMapping : mappings) {
            String filePath = this.rsReader.getFilePath(pMapping.getPath());
            this.registerPathMapping(pMapping, filePath);
        }
    }

    private void register(FilePathMapping pathMapping) throws IOException {
        this.registerPathMapping(pathMapping, pathMapping.getPath());
    }

    private void registerPathMapping(PathMapping pathMapping, String filePath) throws IOException {
        if (filePath != null) {
            Path p = Paths.get(filePath, new String[0]);
            boolean isDir = Files.isDirectory(p, new LinkOption[0]);
            if (!isDir) {
                p = p.getParent();
            }
            if (pathMapping.isRecursive()) {
                this.registerAll(p, Arrays.asList(pathMapping));
            } else {
                this.register(p, Arrays.asList(pathMapping));
            }
        }
    }

    private void removePathMappingFromPathMap(JoinableResourceBundle bundle) {
        for (List<PathMapping> pathMappings : this.pathToResourceBundle.values()) {
            Iterator<PathMapping> iterator = pathMappings.iterator();
            while (iterator.hasNext()) {
                PathMapping pathMapping = iterator.next();
                if (!pathMapping.getBundle().getName().equals(bundle.getName())) continue;
                iterator.remove();
            }
        }
    }

    private void register(Path dir, List<PathMapping> pathMapping) throws IOException {
        WatchKey key = dir.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.keys.put(key, dir);
        List<PathMapping> m = this.pathToResourceBundle.get(dir);
        if (m == null) {
            m = new ArrayList<PathMapping>();
            this.pathToResourceBundle.put(dir, m);
        }
        m.addAll(pathMapping);
    }

    void registerAll(Path start, final List<PathMapping> pathMappings) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                ResourceWatcher.this.register(dir, pathMappings);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void close() {
        try {
            this.bundlesHandler = null;
            this.rsReader = null;
            this.watchService.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.stopWatching.get()) {
            WatchKey key;
            try {
                key = this.watchService.take();
            }
            catch (InterruptedException | ClosedWatchServiceException e) {
                this.close();
                return;
            }
            if (key == null) continue;
            Path dir = this.keys.get(key);
            if (dir == null) {
                LOGGER.warn("WatchKey not recognized!!");
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                Path path = (Path)event.context();
                Path resolvedPath = ((Path)key.watchable()).resolve(path);
                boolean isDir = Files.isDirectory(resolvedPath, LinkOption.NOFOLLOW_LINKS);
                Path dirPath = null;
                dirPath = isDir ? (Path)key.watchable() : resolvedPath.getParent();
                JawrWatchEvent evt = new JawrWatchEvent(kind, resolvedPath, dirPath);
                this.watchEvents.add(evt);
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.keys.remove(key);
            if (!this.keys.isEmpty()) continue;
            break;
        }
        this.close();
    }

    public boolean hasNoEventToProcess() {
        return this.jawrEvtProcessor.hasNoEventToProcess();
    }
}

