/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.servlet;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jawr.web.context.ThreadLocalJawrContext;
import net.jawr.web.exception.InvalidPathException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.BinaryResourcesHandler;
import net.jawr.web.resource.bundle.CheckSumUtils;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.factory.util.PropertiesConfigHelper;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.handler.BundleHashcodeType;
import net.jawr.web.resource.handler.bundle.ResourceBundleHandler;
import net.jawr.web.servlet.JawrRequestHandler;
import net.jawr.web.servlet.util.ClientAbortExceptionResolver;
import net.jawr.web.servlet.util.MIMETypesSupport;
import net.jawr.web.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JawrBinaryResourceRequestHandler
extends JawrRequestHandler {
    private static final long serialVersionUID = -8342090032443416738L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JawrBinaryResourceRequestHandler.class);
    private static final Logger PERF_PROCESSING_LOGGER = LoggerFactory.getLogger((String)"net.jawr.perf.processing");
    private ResourceBundleHandler rsBundleHandler;
    private BinaryResourcesHandler binaryRsHandler;
    private Properties bundleMapping;
    protected Map<Object, Object> binaryMimeTypeMap = MIMETypesSupport.getSupportedProperties(this);

    public JawrBinaryResourceRequestHandler(ServletContext context, ServletConfig config) throws ServletException {
        super(context, config);
        this.resourceType = "binary";
    }

    public JawrBinaryResourceRequestHandler(ServletContext context, Map<String, Object> initParams, Properties configProps) throws ServletException {
        super(context, initParams, configProps);
        this.resourceType = "binary";
    }

    @Override
    protected void initializeJawrConfig(Properties props) throws ServletException {
        StopWatch stopWatch = new StopWatch("Jawr Processing for '" + this.resourceType + "' resource");
        ThreadLocalJawrContext.setStopWatch(stopWatch);
        stopWatch.start("Initialize jawr config for binary resource handler");
        if (this.binaryMimeTypeMap == null) {
            this.binaryMimeTypeMap = MIMETypesSupport.getSupportedProperties(this);
        }
        this.generatorRegistry = new GeneratorRegistry(this.resourceType);
        if (null != this.jawrConfig) {
            this.jawrConfig.invalidate();
        }
        this.jawrConfig = this.createJawrConfig(props);
        this.jawrConfig.setContext(this.servletContext);
        this.jawrConfig.setGeneratorRegistry(this.generatorRegistry);
        String mapping = (String)this.initParameters.get("mapping");
        if (null != mapping) {
            this.jawrConfig.setServletMapping(mapping);
        }
        this.initIllegalBundleRequestHandler();
        this.rsReaderHandler = this.initResourceReaderHandler();
        this.rsBundleHandler = this.initResourceBundleHandler();
        PropertiesConfigHelper propertiesHelper = new PropertiesConfigHelper(props, this.resourceType);
        for (String generatorClass : propertiesHelper.getCommonPropertyAsSet("custom.generators")) {
            this.generatorRegistry.registerGenerator(generatorClass);
        }
        this.bundleMapping = this.jawrConfig.getUseBundleMapping() ? this.rsBundleHandler.getJawrBundleMapping() : new Properties();
        stopWatch.stop();
        stopWatch.start("initialize mapping for binary resource handler");
        this.binaryRsHandler = new BinaryResourcesHandler(this.jawrConfig, this.rsReaderHandler, this.rsBundleHandler);
        this.initMapping(this.binaryRsHandler);
        this.servletContext.setAttribute("net.jawr.web.resource.bundle.BINARY_CONTEXT_ATTRIBUTE", (Object)this.binaryRsHandler);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configuration read. Current config:");
            LOGGER.debug(this.jawrConfig.toString());
        }
        stopWatch.stop();
        stopWatch.start("initialize mapping for binary resource handler");
        if (PERF_PROCESSING_LOGGER.isDebugEnabled()) {
            PERF_PROCESSING_LOGGER.debug(stopWatch.prettyPrint());
        }
        if (this.jawrConfig.isDebugModeOn()) {
            LOGGER.warn("Jawr initialized in DEVELOPMENT MODE. Do NOT use this mode in production or integration servers. ");
        }
        stopWatch.stop();
        if (PERF_PROCESSING_LOGGER.isDebugEnabled()) {
            PERF_PROCESSING_LOGGER.debug(stopWatch.prettyPrint());
        }
    }

    private void initMapping(BinaryResourcesHandler binaryRsHandler) {
        if (this.jawrConfig.getUseBundleMapping() && this.rsBundleHandler.isExistingMappingFile()) {
            for (Map.Entry<Object, Object> entry : this.bundleMapping.entrySet()) {
                binaryRsHandler.addMapping((String)entry.getKey(), entry.getValue().toString());
            }
        } else {
            String binaryResourcesDefinition = this.jawrConfig.getBinaryResourcesDefinition();
            if (binaryResourcesDefinition != null) {
                StringTokenizer tokenizer = new StringTokenizer(binaryResourcesDefinition, ",");
                while (tokenizer.hasMoreTokens()) {
                    String pathMapping = tokenizer.nextToken();
                    if (this.generatorRegistry.isGeneratedBinaryResource(pathMapping) && this.hasBinaryFileExtension(pathMapping)) {
                        this.addBinaryResourcePath(binaryRsHandler, pathMapping);
                        continue;
                    }
                    if (pathMapping.endsWith("/")) {
                        this.addItemsFromDir(binaryRsHandler, pathMapping, false);
                        continue;
                    }
                    if (pathMapping.endsWith("/**")) {
                        this.addItemsFromDir(binaryRsHandler, pathMapping.substring(0, pathMapping.lastIndexOf("**")), true);
                        continue;
                    }
                    if (this.hasBinaryFileExtension(pathMapping)) {
                        this.addBinaryResourcePath(binaryRsHandler, pathMapping);
                        continue;
                    }
                    LOGGER.warn("Wrong mapping [" + pathMapping + "] for image bundle. Please check configuration. ");
                }
            }
        }
        if (this.jawrConfig.getUseBundleMapping() && !this.rsBundleHandler.isExistingMappingFile()) {
            this.rsBundleHandler.storeJawrBundleMapping(this.bundleMapping);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finish creation of map for image bundle");
        }
    }

    private void addBinaryResourcePath(BinaryResourcesHandler binRsHandler, String resourcePath) {
        try {
            String resultPath = CheckSumUtils.getCacheBustedUrl(resourcePath, this.rsReaderHandler, this.jawrConfig);
            binRsHandler.addMapping(resourcePath, resultPath);
            this.bundleMapping.put(resourcePath, resultPath);
        }
        catch (IOException e) {
            LOGGER.error("An exception occurs while defining the mapping for the file : " + resourcePath, (Throwable)e);
        }
        catch (ResourceNotFoundException e) {
            LOGGER.error("Impossible to define the checksum for the resource '" + resourcePath + "'. Unable to retrieve the content of the file.");
        }
    }

    private boolean hasBinaryFileExtension(String path) {
        boolean result = false;
        int extFileIdx = path.lastIndexOf(".");
        if (extFileIdx != -1 && extFileIdx + 1 < path.length()) {
            String extension = path.substring(extFileIdx + 1);
            result = this.binaryMimeTypeMap.containsKey(extension);
        }
        return result;
    }

    private void addItemsFromDir(BinaryResourcesHandler binRsHandler, String dirName, boolean addSubDirs) {
        Set<String> resources = this.rsReaderHandler.getResourceNames(dirName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding " + resources.size() + " resources from path [" + dirName + "] to binary bundle");
        }
        GeneratorRegistry binGeneratorRegistry = binRsHandler.getConfig().getGeneratorRegistry();
        ArrayList<String> folders = new ArrayList<String>();
        boolean generatedPath = binGeneratorRegistry.isPathGenerated(dirName);
        for (String resourceName : resources) {
            String resourcePath = PathNormalizer.joinPaths(dirName, resourceName, generatedPath);
            if (this.hasBinaryFileExtension(resourceName)) {
                this.addBinaryResourcePath(binRsHandler, resourcePath);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Added to item path list:" + PathNormalizer.asPath(resourcePath));
                continue;
            }
            if (!addSubDirs) continue;
            try {
                if (!this.rsReaderHandler.isDirectory(resourcePath)) continue;
                folders.add(resourceName);
            }
            catch (InvalidPathException e) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Enable to define if the following resource is a directory : " + PathNormalizer.asPath(resourcePath));
            }
        }
        if (addSubDirs) {
            for (String folderName : folders) {
                this.addItemsFromDir(binRsHandler, PathNormalizer.joinPaths(dirName, folderName), true);
            }
        }
    }

    @Override
    protected void processRequest(String requestedPath, HttpServletRequest request, HttpServletResponse response, BundleHashcodeType bundleHashcodeType) throws IOException {
        boolean responseHeaderWritten = false;
        boolean validBundle = true;
        if (!this.jawrConfig.isDebugModeOn() && this.jawrConfig.isStrictMode() && bundleHashcodeType.equals((Object)BundleHashcodeType.INVALID_HASHCODE)) {
            validBundle = false;
        }
        if (!this.jawrConfig.isDebugModeOn()) {
            if (validBundle && (null != request.getHeader("If-Modified-Since") || null != request.getHeader("If-None-Match"))) {
                response.setStatus(304);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Returning 'not modified' header. ");
                }
                return;
            }
            if (validBundle) {
                this.setResponseHeaders(response);
            } else {
                responseHeaderWritten = this.illegalBundleRequestHandler.writeResponseHeader(requestedPath, request, response);
                if (!responseHeaderWritten) {
                    this.setResponseHeaders(response);
                }
            }
        }
        String filePath = this.getRealFilePath(requestedPath, bundleHashcodeType);
        try {
            if (this.isValidRequestedPath(filePath) && (validBundle || this.illegalBundleRequestHandler.canWriteContent(requestedPath, request))) {
                response.setContentType(this.getContentType(requestedPath, request));
                this.writeContent(filePath, request, response);
            } else if (!responseHeaderWritten) {
                LOGGER.error("Unable to load the image for the request URI : " + request.getRequestURI());
                response.sendError(404);
            }
        }
        catch (EOFException eofex) {
            LOGGER.info("Browser cut off response", (Throwable)eofex);
        }
        catch (ResourceNotFoundException e) {
            LOGGER.info("Unable to write resource " + request.getRequestURI(), (Throwable)e);
            response.sendError(404);
        }
        catch (IOException ex) {
            LOGGER.error("Unable to write resource " + request.getRequestURI(), (Throwable)ex);
            response.sendError(404);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("request succesfully attended");
        }
    }

    @Override
    protected BundleHashcodeType isValidBundle(String requestedPath) {
        BundleHashcodeType bundleHashcodeType = BundleHashcodeType.VALID_HASHCODE;
        if (!this.jawrConfig.isDebugModeOn()) {
            bundleHashcodeType = this.binaryRsHandler.getBundleHashcodeType(requestedPath);
        }
        return bundleHashcodeType;
    }

    @Override
    protected boolean copyRequestedContentToResponse(String requestedPath, HttpServletResponse response, String contentType) throws IOException {
        boolean copyDone = false;
        if (this.isValidRequestedPath(requestedPath)) {
            try {
                this.writeContent(requestedPath, null, response);
                copyDone = true;
            }
            catch (ResourceNotFoundException e) {
                // empty catch block
            }
        }
        return copyDone;
    }

    @Override
    protected boolean handleSpecificRequest(String requestedPath, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean processed = false;
        if (requestedPath == null) {
            response.sendError(404);
            processed = true;
        } else if (this.getContentType(requestedPath, request) == null) {
            response.sendError(404);
            processed = true;
        }
        return processed;
    }

    @Override
    protected String getContentType(String filePath, HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        String extension = this.getExtension(filePath);
        if (extension == null) {
            LOGGER.info("No extension found for the request URI : " + requestUri);
            return null;
        }
        String binContentType = (String)this.binaryMimeTypeMap.get(extension);
        if (binContentType == null) {
            LOGGER.info("No binary extension match the extension '" + extension + "' for the request URI : " + requestUri);
            return null;
        }
        return binContentType;
    }

    @Override
    protected boolean isValidRequestedPath(String requestedPath) {
        boolean result = true;
        if (requestedPath.startsWith("/WEB-INF/") || requestedPath.startsWith("/META-INF/")) {
            result = false;
        }
        return result;
    }

    @Override
    protected void writeContent(String requestedPath, HttpServletRequest request, HttpServletResponse response) throws IOException, ResourceNotFoundException {
        String resourceName = requestedPath;
        if (!this.jawrConfig.getGeneratorRegistry().isGeneratedBinaryResource(resourceName) && !resourceName.startsWith("/")) {
            resourceName = "/" + resourceName;
        }
        try (InputStream is = this.rsReaderHandler.getResourceAsStream(resourceName);
             ServletOutputStream os = response.getOutputStream();){
            IOUtils.copy(is, (OutputStream)os);
        }
        catch (EOFException eofex) {
            LOGGER.debug("Browser cut off response", (Throwable)eofex);
        }
        catch (IOException e) {
            if (ClientAbortExceptionResolver.isClientAbortException(e)) {
                LOGGER.debug("Browser cut off response", (Throwable)e);
            }
            throw e;
        }
    }

    private String getRealFilePath(String fileName, BundleHashcodeType bundleHashcodeType) {
        String realFilePath = fileName;
        if (bundleHashcodeType.equals((Object)BundleHashcodeType.INVALID_HASHCODE)) {
            int idx = realFilePath.indexOf("/", 1);
            if (idx != -1) {
                realFilePath = realFilePath.substring(idx);
            }
        } else {
            String[] resourceInfo = PathNormalizer.extractBinaryResourceInfo(realFilePath);
            realFilePath = resourceInfo[0];
        }
        return realFilePath;
    }
}

