/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.servlet;

import java.io.IOException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jawr.web.servlet.JawrBinaryResourceRequestHandler;
import net.jawr.web.servlet.JawrRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class JawrServlet
extends HttpServlet
implements ServletContextListener {
    private static final long serialVersionUID = -4551240917172286444L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JawrServlet.class);
    protected JawrRequestHandler requestHandler;

    public void init() throws ServletException {
        try {
            String type = this.getServletConfig().getInitParameter("type");
            this.requestHandler = "binary".equals(type) ? new JawrBinaryResourceRequestHandler(this.getServletContext(), this.getServletConfig()) : new JawrRequestHandler(this.getServletContext(), this.getServletConfig());
        }
        catch (ServletException e) {
            Marker fatal = MarkerFactory.getMarker((String)"FATAL");
            LOGGER.error(fatal, "Jawr servlet with name " + this.getServletConfig().getServletName() + " failed to initialize properly. ");
            LOGGER.error(fatal, "Cause:");
            LOGGER.error(fatal, e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            Marker fatal = MarkerFactory.getMarker((String)"FATAL");
            LOGGER.error(fatal, "Jawr servlet with name " + this.getServletConfig().getServletName() + " failed to initialize properly. ");
            LOGGER.error(fatal, "Cause: ");
            LOGGER.error(fatal, e.getMessage(), e);
            throw new ServletException(e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.requestHandler.doGet(req, resp);
    }

    public void destroy() {
        this.requestHandler.destroy();
    }

    public void contextInitialized(ServletContextEvent sce) {
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.requestHandler.destroy();
    }
}

