/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.servlet;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.config.jmx.JawrApplicationConfigManager;
import net.jawr.web.context.ThreadLocalJawrContext;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.renderer.BundleRenderer;
import net.jawr.web.resource.bundle.renderer.BundleRendererContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererRequestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RendererRequestUtils.class.getName());
    private static final String BUNDLE_RENDERER_CONTEXT_ATTR_PREFIX = "net.jawr.web.resource.renderer.BUNDLE_RENDERER_CONTEXT";
    private static final Pattern IE_USER_AGENT_PATTERN = Pattern.compile("MSIE (\\d+)");
    private static final String ERROR_EXCEPTION = "javax.servlet.error.exception";
    private static final String FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    private static final String JAWR_ERROR_DISPATCH = "net.jawr.error.dispatch";
    private static final String JAWR_FOWARD_DISPATCH = "net.jawr.forward.dispatch";

    public static BundleRendererContext getBundleRendererContext(HttpServletRequest request, BundleRenderer renderer) {
        String bundleRendererCtxAttributeName = BUNDLE_RENDERER_CONTEXT_ATTR_PREFIX + renderer.getResourceType();
        String jawrErrorDispathAttributeName = JAWR_ERROR_DISPATCH + renderer.getResourceType();
        RendererRequestUtils.clearRequestWhenDispatch(request, ERROR_EXCEPTION, bundleRendererCtxAttributeName, jawrErrorDispathAttributeName);
        String jawrForwardDispathAttributeName = JAWR_FOWARD_DISPATCH + renderer.getResourceType();
        RendererRequestUtils.clearRequestWhenDispatch(request, FORWARD_REQUEST_URI, bundleRendererCtxAttributeName, jawrForwardDispathAttributeName);
        BundleRendererContext ctx = (BundleRendererContext)request.getAttribute(bundleRendererCtxAttributeName);
        if (ctx == null) {
            ctx = new BundleRendererContext(request, renderer.getBundler().getConfig());
            request.setAttribute(bundleRendererCtxAttributeName, (Object)ctx);
        }
        return ctx;
    }

    protected static void clearRequestWhenDispatch(HttpServletRequest request, String requestDispatchAttribute, String bundleRendererCtxAttributeName, String jawrDispathAttributeName) {
        if (request.getAttribute(requestDispatchAttribute) != null && request.getAttribute(jawrDispathAttributeName) == null) {
            request.removeAttribute(bundleRendererCtxAttributeName);
            request.setAttribute(jawrDispathAttributeName, (Object)Boolean.TRUE);
        }
    }

    public static void setBundleRendererContext(ServletRequest request, String resourceType, BundleRendererContext ctx) {
        String globalBundleAddedAttributeName = BUNDLE_RENDERER_CONTEXT_ATTR_PREFIX + resourceType;
        request.setAttribute(globalBundleAddedAttributeName, (Object)ctx);
    }

    public static boolean isRequestGzippable(HttpServletRequest req, JawrConfig jawrConfig) {
        boolean rets;
        if (!jawrConfig.isGzipResourcesModeOn()) {
            rets = false;
        } else if (req.getHeader("Accept-Encoding") != null && req.getHeader("Accept-Encoding").contains("gzip")) {
            if (!jawrConfig.isGzipResourcesForIESixOn() && RendererRequestUtils.isIE6orLess(req)) {
                rets = false;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Gzip enablement for IE executed, with result:" + rets);
                }
            } else {
                rets = true;
            }
        } else {
            rets = false;
        }
        return rets;
    }

    public static boolean isIE(HttpServletRequest req) {
        String agent = req.getHeader("User-Agent");
        return null != agent && agent.contains("MSIE");
    }

    public static boolean isIE6orLess(HttpServletRequest req) {
        return RendererRequestUtils.isIEVersionInferiorOrEqualTo(req, 6);
    }

    public static boolean isIE7orLess(HttpServletRequest req) {
        return RendererRequestUtils.isIEVersionInferiorOrEqualTo(req, 7);
    }

    private static boolean isIEVersionInferiorOrEqualTo(HttpServletRequest req, int ieVersion) {
        int version;
        Matcher matcher;
        boolean result = false;
        String agent = req.getHeader("User-Agent");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("User-Agent for this request:" + agent);
        }
        if (agent != null && (matcher = IE_USER_AGENT_PATTERN.matcher(agent)).find() && (version = Integer.parseInt(matcher.group(1))) <= ieVersion) {
            result = true;
        }
        return result;
    }

    public static void setRequestDebuggable(HttpServletRequest req, JawrConfig jawrConfig) {
        if (jawrConfig.getDebugOverrideKey().length() > 0 && null != req.getParameter("overrideKey") && jawrConfig.getDebugOverrideKey().equals(req.getParameter("overrideKey"))) {
            ThreadLocalJawrContext.setDebugOverriden(true);
        } else {
            ThreadLocalJawrContext.setDebugOverriden(false);
        }
        RendererRequestUtils.inheritSessionDebugProperty(req);
    }

    public static void inheritSessionDebugProperty(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            String sessionId = session.getId();
            JawrApplicationConfigManager appConfigMgr = (JawrApplicationConfigManager)session.getServletContext().getAttribute("net.jawr.web.jmx.JAWR_APPLICATION_CONFIG_MANAGER");
            if (appConfigMgr != null && appConfigMgr.isDebugSessionId(sessionId)) {
                ThreadLocalJawrContext.setDebugOverriden(true);
            }
        }
    }

    public static boolean isSslRequest(HttpServletRequest request) {
        String scheme = request.getScheme();
        return "https".equals(scheme);
    }

    public static String getRenderedUrl(String url, JawrConfig jawrConfig, String contextPath, boolean sslRequest) {
        String contextPathOverride = RendererRequestUtils.getContextPathOverride(sslRequest, jawrConfig);
        String renderedUrl = url;
        if (contextPathOverride != null && (jawrConfig.isDebugModeOn() && jawrConfig.isUseContextPathOverrideInDebugMode() || !jawrConfig.isDebugModeOn())) {
            String override = contextPathOverride;
            if ("".equals(override)) {
                if (url.startsWith("/")) {
                    renderedUrl = renderedUrl.substring(1);
                }
            } else {
                renderedUrl = PathNormalizer.joinPaths(override, renderedUrl);
            }
        } else {
            renderedUrl = PathNormalizer.joinPaths(contextPath, renderedUrl);
        }
        return renderedUrl;
    }

    private static String getContextPathOverride(boolean isSslRequest, JawrConfig config) {
        String contextPathOverride = null;
        contextPathOverride = isSslRequest ? config.getContextPathSslOverride() : config.getContextPathOverride();
        return contextPathOverride;
    }

    public static boolean refreshConfigIfNeeded(HttpServletRequest request, JawrConfig jawrConfig) {
        boolean refreshed = false;
        if (request.getAttribute("jawr.bundle.refresh.check") == null) {
            request.setAttribute("jawr.bundle.refresh.check", (Object)Boolean.TRUE);
            if (jawrConfig.getRefreshKey().length() > 0 && null != request.getParameter("refreshKey") && jawrConfig.getRefreshKey().equals(request.getParameter("refreshKey"))) {
                JawrApplicationConfigManager appConfigMgr = (JawrApplicationConfigManager)request.getSession().getServletContext().getAttribute("net.jawr.web.jmx.JAWR_APPLICATION_CONFIG_MANAGER");
                if (appConfigMgr == null) {
                    throw new IllegalStateException("JawrApplicationConfigManager is not present in servlet context. Initialization of Jawr either failed or never occurred.");
                }
                appConfigMgr.refreshConfig();
                refreshed = true;
            }
        }
        return refreshed;
    }
}

