/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesUtils.class);

    private PropertiesUtils() {
    }

    public static Map<String, String> filterProperties(Properties props, String prefix, boolean removePrefix) {
        List<String> excludedProperties = Collections.emptyList();
        return PropertiesUtils.filterProperties(props, prefix, removePrefix, excludedProperties);
    }

    public static Map<String, String> filterProperties(Properties props, String prefix, boolean removePrefix, List<String> excludedProperties) {
        HashMap<String, String> filteredProps = new HashMap<String, String>();
        Set<Map.Entry<Object, Object>> entrySet = props.entrySet();
        for (Map.Entry<Object, Object> propEntry : entrySet) {
            String key = (String)propEntry.getKey();
            if (!key.startsWith(prefix)) continue;
            String newKey = key;
            if (removePrefix) {
                newKey = key.substring(prefix.length());
            }
            if (!excludedProperties.contains(key)) {
                filteredProps.put(newKey, (String)propEntry.getValue());
                continue;
            }
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn("The property '" + key + "' has been excluded.");
        }
        return filteredProps;
    }
}

