/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.util.js;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.jawr.web.exception.BundlingProcessException;

public class JavascriptEngine
implements Invocable {
    private static final String UNKNOWN_SCRIPT = "Unknown script";
    private ScriptEngine scriptEngine;

    public JavascriptEngine() {
        this("mozilla.rhino", false);
    }

    public JavascriptEngine(boolean initGlobal) {
        this("mozilla.rhino", initGlobal);
    }

    public JavascriptEngine(String scriptEngineName) {
        this(scriptEngineName, false);
    }

    public JavascriptEngine(String scriptEngineName, boolean initGlobal) {
        ScriptEngineManager manager = new ScriptEngineManager();
        this.scriptEngine = manager.getEngineByName(scriptEngineName);
        if (initGlobal) {
            try {
                Object global = this.scriptEngine.eval("eval(this)");
                this.scriptEngine.put("window", global);
                this.scriptEngine.put("global", global);
            }
            catch (ScriptException e) {
                throw new BundlingProcessException(e);
            }
        }
    }

    public ScriptContext getContext() {
        return this.scriptEngine.getContext();
    }

    public Object evaluate(Reader reader) {
        return this.evaluate(UNKNOWN_SCRIPT, reader);
    }

    public Object evaluate(String scriptName, Reader reader) {
        try {
            this.scriptEngine.put("javax.script.filename", scriptName);
            return this.scriptEngine.eval(reader);
        }
        catch (ScriptException e) {
            throw new BundlingProcessException("Error while evaluating script : " + scriptName, e);
        }
    }

    public Object evaluate(String script) {
        return this.evaluate(UNKNOWN_SCRIPT, script);
    }

    public Object evaluate(String scriptName, String script) {
        try {
            this.scriptEngine.put("javax.script.filename", scriptName);
            return this.scriptEngine.eval(script);
        }
        catch (ScriptException e) {
            throw new BundlingProcessException("Error while evaluating script : " + scriptName, e);
        }
    }

    public Object evaluateString(String scriptName, String source, Bindings bindings) {
        try {
            this.scriptEngine.put("javax.script.filename", scriptName);
            return this.scriptEngine.eval(source, bindings);
        }
        catch (ScriptException e) {
            throw new BundlingProcessException("Error while evaluating script : " + scriptName, e);
        }
    }

    public Object evaluate(String scriptName, InputStream stream) {
        return this.evaluate(scriptName, new InputStreamReader(stream));
    }

    public JavascriptEngine evaluateInChain(String scriptName, InputStream stream) {
        this.evaluate(scriptName, stream);
        return this;
    }

    public Bindings createBindings() {
        return this.scriptEngine.createBindings();
    }

    public Bindings getBindings() {
        return this.getBindings(100);
    }

    public Bindings getBindings(int scope) {
        return this.scriptEngine.getBindings(100);
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return ((Invocable)((Object)this.scriptEngine)).invokeMethod(thiz, name, args);
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return ((Invocable)((Object)this.scriptEngine)).invokeFunction(name, args);
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        return ((Invocable)((Object)this.scriptEngine)).getInterface(clasz);
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        return ((Invocable)((Object)this.scriptEngine)).getInterface(thiz, clasz);
    }

    public Object parseJSON(String strJson) throws ScriptException, NoSuchMethodException {
        Object json = this.scriptEngine.eval("JSON");
        Object data = this.invokeMethod(json, "parse", strJson);
        return data;
    }

    public Object execEval(String arg) {
        try {
            return this.scriptEngine.eval("eval(" + arg + ")");
        }
        catch (ScriptException e) {
            throw new BundlingProcessException("Error while evaluating a script", e);
        }
    }
}

