/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.util.js.rhino;

import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.jawr.web.util.js.rhino.RhinoScriptEngine;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

final class RhinoCompiledScript
extends CompiledScript {
    private RhinoScriptEngine engine;
    private Script script;

    RhinoCompiledScript(RhinoScriptEngine engine, Script script) {
        this.engine = engine;
        this.script = script;
    }

    @Override
    public Object eval(ScriptContext context) throws ScriptException {
        Object result = null;
        Context cx = RhinoScriptEngine.enterContext();
        try {
            Scriptable scope = this.engine.getRuntimeScope(context);
            Object ret = this.script.exec(cx, scope);
            result = this.engine.unwrapReturnValue(ret);
        }
        catch (RhinoException re) {
            int line = re.lineNumber();
            line = line == 0 ? -1 : line;
            String msg = re instanceof JavaScriptException ? String.valueOf(((JavaScriptException)re).getValue()) : re.toString();
            ScriptException se = new ScriptException(msg, re.sourceName(), line);
            se.initCause(re);
            throw se;
        }
        finally {
            Context.exit();
        }
        return result;
    }

    @Override
    public ScriptEngine getEngine() {
        return this.engine;
    }
}

