/*
 * Decompiled with CFR 0.152.
 */
package net.jazdw.rql.converter;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.jazdw.rql.converter.AutoValueConverter;
import net.jazdw.rql.converter.ConverterException;
import net.jazdw.rql.converter.ValueConverter;
import org.apache.commons.lang3.math.NumberUtils;

public class DefaultValueConverter
implements ValueConverter<Object> {
    public static final Map<String, ValueConverter<?>> CONVERTERS = Map.of("number", NumberConverter.INSTANCE, "epoch", EpochTimestampConverter.INSTANCE, "date", GenericDateTimeConverter.INSTANCE, "boolean", BooleanConverter.INSTANCE, "string", StringConverter.INSTANCE);
    private final ValueConverter<?> defaultConverter;
    private final HashMap<String, ValueConverter<?>> converterMap;

    public DefaultValueConverter() {
        this(new AutoValueConverter(), CONVERTERS);
    }

    public DefaultValueConverter(ValueConverter<?> defaultConverter) {
        this(defaultConverter, CONVERTERS);
    }

    public DefaultValueConverter(Map<String, ValueConverter<?>> converterMap) {
        this(new AutoValueConverter(), converterMap);
    }

    public DefaultValueConverter(ValueConverter<?> defaultConverter, Map<String, ValueConverter<?>> converterMap) {
        this.defaultConverter = defaultConverter;
        this.converterMap = new HashMap(converterMap);
    }

    @Override
    public Object convert(String textValue) {
        return this.defaultConverter.convert(textValue);
    }

    @Override
    public Object convert(String type, String textValue) {
        ValueConverter<?> converter = this.converterMap.get(type);
        if (converter == null) {
            throw new IllegalArgumentException("Unknown converter type '" + type + "'");
        }
        return converter.convert(textValue);
    }

    public static class NumberConverter
    implements ValueConverter<Number> {
        public static final NumberConverter INSTANCE = new NumberConverter();

        @Override
        public Number convert(String textValue) {
            try {
                return NumberUtils.createNumber((String)textValue);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class EpochTimestampConverter
    implements ValueConverter<Instant> {
        public static final EpochTimestampConverter INSTANCE = new EpochTimestampConverter();

        @Override
        public Instant convert(String textValue) {
            try {
                return Instant.ofEpochMilli(Long.parseLong(textValue));
            }
            catch (NumberFormatException | DateTimeException e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class GenericDateTimeConverter
    implements ValueConverter<Temporal> {
        public static final GenericDateTimeConverter INSTANCE = new GenericDateTimeConverter();

        @Override
        public Temporal convert(String textValue) {
            try {
                return ZonedDateTimeConverter.INSTANCE.convert(textValue);
            }
            catch (ConverterException converterException) {
                try {
                    return LocalDateTimeConverter.INSTANCE.convert(textValue);
                }
                catch (ConverterException converterException2) {
                    return LocalDateConverter.INSTANCE.convert(textValue);
                }
            }
        }
    }

    public static class BooleanConverter
    implements ValueConverter<Boolean> {
        public static final BooleanConverter INSTANCE = new BooleanConverter();

        @Override
        public Boolean convert(String textValue) {
            try {
                return Boolean.parseBoolean(textValue);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class StringConverter
    implements ValueConverter<String> {
        public static final StringConverter INSTANCE = new StringConverter();

        @Override
        public String convert(String textValue) {
            try {
                return Objects.requireNonNull(textValue);
            }
            catch (NullPointerException e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class RegexConverter
    implements ValueConverter<Pattern> {
        public static final RegexConverter INSTANCE = new RegexConverter();

        @Override
        public Pattern convert(String textValue) {
            try {
                return Pattern.compile(textValue);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class CaseInsensitiveRegexConverter
    implements ValueConverter<Pattern> {
        public static final CaseInsensitiveRegexConverter INSTANCE = new CaseInsensitiveRegexConverter();

        @Override
        public Pattern convert(String textValue) {
            try {
                return Pattern.compile(textValue, 66);
            }
            catch (Exception e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class LocalDateConverter
    implements ValueConverter<LocalDate> {
        public static final LocalDateConverter INSTANCE = new LocalDateConverter();

        @Override
        public LocalDate convert(String textValue) {
            try {
                return LocalDate.parse(textValue, DateTimeFormatter.ISO_LOCAL_DATE);
            }
            catch (DateTimeParseException e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class LocalDateTimeConverter
    implements ValueConverter<LocalDateTime> {
        public static final LocalDateTimeConverter INSTANCE = new LocalDateTimeConverter();

        @Override
        public LocalDateTime convert(String textValue) {
            try {
                return LocalDateTime.parse(textValue, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                throw new ConverterException(e);
            }
        }
    }

    public static class ZonedDateTimeConverter
    implements ValueConverter<ZonedDateTime> {
        public static final ZonedDateTimeConverter INSTANCE = new ZonedDateTimeConverter();

        @Override
        public ZonedDateTime convert(String textValue) {
            try {
                return ZonedDateTime.parse(textValue, DateTimeFormatter.ISO_ZONED_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                throw new ConverterException(e);
            }
        }
    }
}

