/*
 * Decompiled with CFR 0.152.
 */
package net.jfuentestgn.htmlsanitizer;

import net.jfuentestgn.htmlsanitizer.PoliciesRegistry;
import net.jfuentestgn.htmlsanitizer.Sanitizer;
import net.jfuentestgn.htmlsanitizer.SanitizerFormatterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class HtmlSanitizerConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(HtmlSanitizerConfiguration.class);

    @Bean
    public PoliciesRegistry policiesRegistry() {
        log.info("[m:policiesRegistry] Instantiating bean 'PoliciesRegistry'");
        PoliciesRegistry policiesRegistry = new PoliciesRegistry();
        policiesRegistry.addPredefinedPolicies();
        return policiesRegistry;
    }

    @Bean
    public Sanitizer sanitizer() {
        log.info("[m:sanitizer] Instantiating bean 'Sanitizer'");
        return new Sanitizer(this.policiesRegistry());
    }

    @Bean
    SanitizerFormatterFactory sanitizerFormatterFactory() {
        log.info("[m:sanitizerFormatterFactory] Instantiating bean 'SanitizerFormatterFactory'");
        return new SanitizerFormatterFactory(this.sanitizer());
    }

    public void addFormatters(FormatterRegistry registry) {
        log.info("[m:addFormatters] Adding 'SanitizerFormatterFactory' formatter to FormatterRegistry");
        registry.addFormatterForFieldAnnotation((AnnotationFormatterFactory)this.sanitizerFormatterFactory());
    }
}

