/*
 * Decompiled with CFR 0.152.
 */
package net.jfuentestgn.htmlsanitizer;

import java.util.HashMap;
import java.util.Map;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoliciesRegistry {
    private static final Logger log = LoggerFactory.getLogger(PoliciesRegistry.class);
    private final Map<String, PolicyFactory> policies = new HashMap<String, PolicyFactory>();

    public void addPredefinedPolicies() {
        this.registerPolicy("DEFAULT", new HtmlPolicyBuilder().toFactory());
        this.registerPolicy("BLOCKS", Sanitizers.BLOCKS);
        this.registerPolicy("FORMATTING", Sanitizers.FORMATTING);
        this.registerPolicy("IMAGES", Sanitizers.IMAGES);
        this.registerPolicy("LINKS", Sanitizers.LINKS);
        this.registerPolicy("STYLES", Sanitizers.STYLES);
        this.registerPolicy("TABLES", Sanitizers.TABLES);
    }

    public void registerPolicy(String name, PolicyFactory policy) {
        this.policies.put(name, policy);
    }

    public PolicyFactory getPolicy(String name) {
        return this.policies.get(name);
    }
}

