/*
 * Decompiled with CFR 0.152.
 */
package net.jfuentestgn.htmlsanitizer;

import net.jfuentestgn.htmlsanitizer.PoliciesRegistry;
import org.owasp.html.PolicyFactory;

public class Sanitizer {
    public static final String DEFAULT = "DEFAULT";
    public static final String BLOCKS = "BLOCKS";
    public static final String FORMATTING = "FORMATTING";
    public static final String IMAGES = "IMAGES";
    public static final String LINKS = "LINKS";
    public static final String STYLES = "STYLES";
    public static final String TABLES = "TABLES";
    private final PoliciesRegistry registry;

    public Sanitizer(PoliciesRegistry registry) {
        this.registry = registry;
    }

    public String sanitize(String name, String html) {
        PolicyFactory policy = this.registry.getPolicy(name);
        if (policy == null) {
            throw new IllegalArgumentException("Policy not found: " + name);
        }
        return policy.sanitize(html);
    }
}

