/*
 * Decompiled with CFR 0.152.
 */
package net.jfuentestgn.htmlsanitizer;

import java.util.Set;
import net.jfuentestgn.htmlsanitizer.Sanitize;
import net.jfuentestgn.htmlsanitizer.Sanitizer;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Parser;
import org.springframework.format.Printer;

public class SanitizerFormatterFactory
implements AnnotationFormatterFactory<Sanitize> {
    private static final Set<Class<?>> FIELD_TYPES = Set.of(String.class);
    private final Sanitizer sanitizer;

    public SanitizerFormatterFactory(Sanitizer sanitizer) {
        this.sanitizer = sanitizer;
    }

    public Set<Class<?>> getFieldTypes() {
        return FIELD_TYPES;
    }

    public Printer<String> getPrinter(Sanitize annotation, Class<?> fieldType) {
        return (text, locale) -> text;
    }

    public Parser<String> getParser(Sanitize annotation, Class<?> fieldType) {
        return (text, locale) -> this.sanitizer.sanitize(annotation.value(), text);
    }
}

