/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.thread.Executor;
import java.util.HashMap;
import java.util.Map;

class TimedMap {
    private final Executor executor;
    private final long timeout;
    private final Map map = new HashMap();
    private final Queue evictQueue = new Queue();
    private boolean evictorActive = false;

    TimedMap(Executor executor, long timeout) {
        if (executor == null) {
            throw new NullPointerException();
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        this.executor = executor;
        this.timeout = timeout;
    }

    synchronized Object put(Object key, Object value) {
        if (!this.evictorActive) {
            this.executor.execute(new Evictor(), "TimedMap evictor");
            this.evictorActive = true;
        }
        long now = System.currentTimeMillis();
        Mapping mapping = new Mapping(key, value, now + this.timeout);
        this.evictQueue.append(mapping);
        mapping = this.map.put(key, mapping);
        if (mapping == null) {
            return null;
        }
        if (mapping.expiry <= now) {
            mapping.remove = false;
            return null;
        }
        this.evictQueue.remove(mapping);
        return mapping.value;
    }

    synchronized Object get(Object key) {
        Mapping mapping = (Mapping)this.map.get(key);
        if (mapping == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        if (mapping.expiry <= now) {
            return null;
        }
        this.evictQueue.remove(mapping);
        mapping.expiry = now + this.timeout;
        this.evictQueue.append(mapping);
        return mapping.value;
    }

    synchronized Object remove(Object key) {
        Mapping mapping = (Mapping)this.map.remove(key);
        if (mapping == null) {
            return null;
        }
        if (mapping.expiry <= System.currentTimeMillis()) {
            mapping.remove = false;
            return null;
        }
        this.evictQueue.remove(mapping);
        return mapping.value;
    }

    void evicted(Object key, Object value) {
    }

    private static class Queue {
        private Node head = new Node();
        private Node tail = new Node();

        Queue() {
            this.head.next = this.tail;
            this.tail.prev = this.head;
        }

        Node getHead() {
            return this.head.next != this.tail ? this.head.next : null;
        }

        void remove(Node node) {
            if (node.owner != this) {
                throw new IllegalArgumentException();
            }
            node.prev.next = node.next;
            node.next.prev = node.prev;
            node.prev = (node.next = null);
            node.owner = null;
        }

        void append(Node node) {
            if (node.owner != null) {
                throw new IllegalArgumentException();
            }
            node.owner = this;
            node.prev = this.tail.prev;
            node.next = this.tail;
            this.tail.prev.next = node;
            this.tail.prev = node;
        }

        static class Node {
            private Queue owner;
            private Node prev;
            private Node next;

            Node() {
            }
        }
    }

    private class Evictor
    implements Runnable {
        private Evictor() {
        }

        public void run() {
            Mapping mapping;
            while ((mapping = this.nextEvicted()) != null) {
                TimedMap.this.evicted(mapping.key, mapping.value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Mapping nextEvicted() {
            TimedMap timedMap = TimedMap.this;
            synchronized (timedMap) {
                while (true) {
                    Mapping mapping;
                    if ((mapping = (Mapping)TimedMap.this.evictQueue.getHead()) == null) {
                        TimedMap.this.evictorActive = false;
                        return null;
                    }
                    long now = System.currentTimeMillis();
                    if (mapping.expiry <= now) {
                        TimedMap.this.evictQueue.remove(mapping);
                        if (mapping.remove) {
                            TimedMap.this.map.remove(mapping.key);
                        }
                        return mapping;
                    }
                    try {
                        TimedMap.this.wait(mapping.expiry - now);
                    }
                    catch (InterruptedException ex) {
                    }
                }
            }
        }
    }

    private static class Mapping
    extends Queue.Node {
        final Object key;
        final Object value;
        long expiry;
        boolean remove = true;

        Mapping(Object key, Object value, long expiry) {
            this.key = key;
            this.value = value;
            this.expiry = expiry;
        }
    }
}

