/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.security.Permission;

public class AccessPermission
extends Permission {
    private static final long serialVersionUID = 7269818741475881138L;
    private transient String iface;
    private transient String method;

    public AccessPermission(String name) {
        super(name);
        this.init(name);
    }

    private void init(String name) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        int i = name.lastIndexOf(46);
        if (i >= 0) {
            this.iface = name.substring(0, i);
            name = name.substring(i + 1);
        }
        if (!name.equals("*")) {
            this.method = name;
        }
        if (this.iface != null && !AccessPermission.validClass(this.iface)) {
            throw new IllegalArgumentException("invalid interface name");
        }
        if (this.method != null && !AccessPermission.validMethod(this.method)) {
            throw new IllegalArgumentException("invalid method name");
        }
    }

    private static boolean validClass(String name) {
        int len = name.length();
        block0: for (int i = 0; i < len && Character.isJavaIdentifierStart(name.charAt(i)); ++i) {
            while (++i < len) {
                char c = name.charAt(i);
                if (c == '.') continue block0;
                if (Character.isJavaIdentifierPart(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean validMethod(String name) {
        int len = name.length();
        if (len == 0) {
            return false;
        }
        char c = name.charAt(0);
        if (!(Character.isJavaIdentifierStart(c) || c == '*' && len > 1)) {
            return false;
        }
        if (c != '*' && name.charAt(len - 1) == '*') {
            --len;
        }
        while (--len >= 1) {
            if (Character.isJavaIdentifierPart(name.charAt(len))) continue;
            return false;
        }
        return true;
    }

    public boolean implies(Permission perm) {
        if (perm == null || perm.getClass() != this.getClass()) {
            return false;
        }
        AccessPermission ap = (AccessPermission)perm;
        if (this.iface != null && !this.iface.equals(ap.iface)) {
            return false;
        }
        if (this.method == null) {
            return true;
        }
        if (ap.method == null) {
            return false;
        }
        int len = this.method.length() - 1;
        if (this.method.charAt(0) == '*') {
            return ap.method.regionMatches(ap.method.length() - len, this.method, 1, len);
        }
        if (this.method.charAt(len) == '*') {
            return ap.method.regionMatches(0, this.method, 0, len);
        }
        return this.method.equals(ap.method);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.getName().equals(((Permission)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        RuntimeException cause;
        s.defaultReadObject();
        try {
            this.init(this.getName());
            return;
        }
        catch (NullPointerException e) {
            cause = e;
        }
        catch (IllegalArgumentException e) {
            cause = e;
        }
        InvalidObjectException e = new InvalidObjectException(cause.getMessage());
        e.initCause(cause);
        throw e;
    }
}

