/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import com.sun.jini.proxy.MarshalledWrapper;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.jini.core.event.RemoteEvent;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.LookupUnmarshalException;
import net.jini.io.MarshalledInstance;

public class RemoteDiscoveryEvent
extends RemoteEvent {
    private static final long serialVersionUID = -9171289945014585248L;
    protected boolean discarded;
    protected ArrayList marshalledRegs;
    protected ServiceRegistrar[] regs;
    protected Map groups;
    private transient boolean integrity;

    public RemoteDiscoveryEvent(Object source, long eventID, long seqNum, MarshalledObject handback, boolean discarded, Map groups) throws IOException {
        super(source, eventID, seqNum, handback);
        this.discarded = discarded;
        if (groups != null) {
            int i;
            if (groups.size() == 0) {
                throw new IllegalArgumentException("empty input map");
            }
            ServiceRegistrar[] registrars = groups.keySet().toArray(new ServiceRegistrar[groups.size()]);
            for (i = 0; i < registrars.length; ++i) {
                if (registrars[i] != null) continue;
                throw new NullPointerException("null element (" + i + ") in input map");
            }
            this.groups = new HashMap(groups.size());
            this.marshalledRegs = new ArrayList(groups.size());
            for (i = 0; i < registrars.length; ++i) {
                try {
                    this.marshalledRegs.add(new MarshalledObject<ServiceRegistrar>(registrars[i]));
                    this.groups.put(registrars[i].getServiceID(), groups.get(registrars[i]));
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.marshalledRegs.isEmpty()) {
                throw new IOException("failed to serialize any of the " + registrars.length + " elements");
            }
        } else {
            throw new NullPointerException("null input map");
        }
        this.regs = new ServiceRegistrar[this.marshalledRegs.size()];
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistrar[] getRegistrars() throws LookupUnmarshalException {
        ArrayList arrayList = this.marshalledRegs;
        synchronized (arrayList) {
            if (this.marshalledRegs.size() > 0) {
                ArrayList unmarshalledRegs = new ArrayList();
                ArrayList exceptions = this.unmarshalRegistrars(this.marshalledRegs, unmarshalledRegs);
                RemoteDiscoveryEvent.insertRegistrars(this.regs, unmarshalledRegs);
                if (exceptions.size() > 0) {
                    throw new LookupUnmarshalException(RemoteDiscoveryEvent.clipNullsFromEnd(this.regs), this.marshalledRegs.toArray(new MarshalledObject[this.marshalledRegs.size()]), exceptions.toArray(new Throwable[exceptions.size()]), "failed to unmarshal at least one ServiceRegistrar");
                }
            }
            return RemoteDiscoveryEvent.clipNullsFromEnd(this.regs);
        }
    }

    public Map getGroups() {
        return this.groups;
    }

    private ArrayList unmarshalRegistrars(ArrayList marshalledRegs, ArrayList unmarshalledRegs) {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        int i = 0;
        int nMarshalledRegs = marshalledRegs.size();
        for (int n = 0; n < nMarshalledRegs; ++n) {
            MarshalledObject marshalledObj = (MarshalledObject)marshalledRegs.get(i);
            MarshalledInstance marshalledInstance = new MarshalledInstance(marshalledObj);
            try {
                ServiceRegistrar reg = (ServiceRegistrar)marshalledInstance.get(this.integrity);
                unmarshalledRegs.add(reg);
                marshalledRegs.remove(i);
                continue;
            }
            catch (Throwable e) {
                exceptions.add(e);
                ++i;
            }
        }
        return exceptions;
    }

    private static void insertRegistrars(ServiceRegistrar[] regsArray, ArrayList regsList) {
        if (regsArray != null && regsList != null) {
            int lenA = regsArray.length;
            int lenB = regsList.size();
            if (lenA == 0 || lenB == 0) {
                return;
            }
            int beg = RemoteDiscoveryEvent.indexFirstNull(regsArray);
            int end = beg + lenB <= lenA ? beg + lenB : lenA;
            int i = beg;
            int j = 0;
            while (i < end) {
                regsArray[i] = (ServiceRegistrar)regsList.get(j);
                ++i;
                ++j;
            }
        }
    }

    private static ServiceRegistrar[] clipNullsFromEnd(ServiceRegistrar[] regsArray) {
        if (regsArray == null) {
            return new ServiceRegistrar[0];
        }
        int clippedLen = RemoteDiscoveryEvent.indexFirstNull(regsArray);
        ServiceRegistrar[] clippedArray = new ServiceRegistrar[clippedLen];
        for (int i = 0; i < clippedLen; ++i) {
            clippedArray[i] = regsArray[i];
        }
        return clippedArray;
    }

    private static int indexFirstNull(Object[] arr) {
        int i = -1;
        if (arr == null || arr.length == 0) {
            return i;
        }
        for (i = 0; i < arr.length; ++i) {
            if (arr[i] != null) continue;
            return i;
        }
        return i;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.source == null) {
            throw new InvalidObjectException("RemoteDiscoveryEvent.readObject failure - source field is null");
        }
        this.integrity = MarshalledWrapper.integrityEnforced(s);
    }
}

