/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.rmi.MarshalledObject;
import net.jini.core.lookup.ServiceRegistrar;

public class LookupUnmarshalException
extends Exception {
    private static final long serialVersionUID = 2956893184719950537L;
    private ServiceRegistrar[] registrars = null;
    private MarshalledObject[] marshalledRegistrars = null;
    private Throwable[] exceptions = null;

    public LookupUnmarshalException(ServiceRegistrar[] registrars, MarshalledObject[] marshalledRegistrars, Throwable[] exceptions) {
        this.init(registrars, marshalledRegistrars, exceptions);
    }

    public LookupUnmarshalException(ServiceRegistrar[] registrars, MarshalledObject[] marshalledRegistrars, Throwable[] exceptions, String message) {
        super(message);
        this.init(registrars, marshalledRegistrars, exceptions);
    }

    public ServiceRegistrar[] getRegistrars() {
        return this.registrars;
    }

    public MarshalledObject[] getMarshalledRegistrars() {
        return this.marshalledRegistrars;
    }

    public Throwable[] getExceptions() {
        return this.exceptions;
    }

    private void init(ServiceRegistrar[] registrars, MarshalledObject[] marshalledRegistrars, Throwable[] exceptions) {
        if (marshalledRegistrars == null) {
            throw new NullPointerException("marshalledRegistrars cannot be null");
        }
        if (exceptions == null) {
            throw new NullPointerException("exceptions cannot be null");
        }
        if (marshalledRegistrars.length == 0) {
            throw new IllegalArgumentException("marshalledRegistrars has 0 length");
        }
        if (exceptions.length != marshalledRegistrars.length) {
            throw new IllegalArgumentException("exceptions.length (" + exceptions.length + ") is not equal to marshalledRegistrars.length " + "(" + marshalledRegistrars.length + ")");
        }
        this.registrars = registrars;
        this.marshalledRegistrars = marshalledRegistrars;
        this.exceptions = exceptions;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.marshalledRegistrars == null) {
            throw new InvalidObjectException("LookupUnmarshalException.readObject failure - marshalledRegistrars field is null");
        }
        if (this.exceptions == null) {
            throw new InvalidObjectException("LookupUnmarshalException.readObject failure - exceptions field is null");
        }
        if (this.marshalledRegistrars.length == 0) {
            throw new InvalidObjectException("LookupUnmarshalException.readObject failure - marshalledRegistrars.length == 0");
        }
        if (this.exceptions.length != this.marshalledRegistrars.length) {
            throw new InvalidObjectException("LookupUnmarshalException.readObject failure - exceptions.length (" + this.exceptions.length + ") is not equal to marshalledRegistrars.length " + "(" + this.marshalledRegistrars.length + ")");
        }
    }
}

