/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.mux;

import com.sun.jini.jeri.internal.mux.IOFuture;
import com.sun.jini.jeri.internal.mux.Mux;
import com.sun.jini.jeri.internal.mux.MuxClient;
import com.sun.jini.jeri.internal.mux.MuxServer;
import com.sun.jini.jeri.internal.mux.ProtocolException;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.io.context.AcknowledgmentSource;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.OutboundRequest;

final class Session {
    static final int CLIENT = 0;
    static final int SERVER = 1;
    private static final int IDLE = 0;
    private static final int OPEN = 1;
    private static final int FINISHED = 2;
    private static final int TERMINATED = 3;
    private static final String[] stateNames = new String[]{"idle", "open", "finished", "terminated"};
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private static final Logger logger = Logger.getLogger("net.jini.jeri.connection.mux");
    private final Mux mux;
    private final int sessionID;
    private final int role;
    private final OutputStream out;
    private final InputStream in;
    private final Object sessionLock = new Object();
    private boolean sessionDown = false;
    private String sessionDownMessage;
    private Throwable sessionDownCause;
    private int outState;
    private int outRation;
    private final boolean outRationInfinite;
    private boolean partialDeliveryStatus = false;
    private int inState;
    private int inRation;
    private final boolean inRationInfinite;
    private int inBufRemaining = 0;
    private final LinkedList inBufQueue = new LinkedList();
    private int inBufPos = 0;
    private boolean inEOF = false;
    private boolean inClosed = false;
    private boolean fakeOKtoWrite = false;
    private boolean removeLater = false;
    private boolean receivedAckRequired = false;
    private boolean sentAcknowledgment = false;
    private Collection ackListeners = null;
    private boolean sentAckRequired = false;
    private boolean receivedAcknowledgment = false;

    Session(Mux mux, int sessionID, int role) {
        this.mux = mux;
        this.sessionID = sessionID;
        this.role = role;
        this.out = new MuxOutputStream();
        this.in = new MuxInputStream();
        this.outState = role == 0 ? 0 : 1;
        this.outRation = mux.initialOutboundRation;
        this.outRationInfinite = this.outRation == 0;
        this.inState = role == 0 ? 0 : 1;
        this.inRation = mux.initialInboundRation;
        this.inRationInfinite = this.inRation == 0;
    }

    OutboundRequest getOutboundRequest() {
        assert (this.role == 0);
        return new OutboundRequest(){

            public void populateContext(Collection context) {
                ((MuxClient)Session.this.mux).populateContext(context);
            }

            public InvocationConstraints getUnfulfilledConstraints() {
                throw new AssertionError();
            }

            public OutputStream getRequestOutputStream() {
                return Session.this.out;
            }

            public InputStream getResponseInputStream() {
                return Session.this.in;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean getDeliveryStatus() {
                Object object = Session.this.sessionLock;
                synchronized (object) {
                    return Session.this.partialDeliveryStatus;
                }
            }

            public void abort() {
                Session.this.abort();
            }
        };
    }

    InboundRequest getInboundRequest() {
        assert (this.role == 1);
        return new InboundRequest(){

            public void checkPermissions() {
                ((MuxServer)Session.this.mux).checkPermissions();
            }

            public InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
                return ((MuxServer)Session.this.mux).checkConstraints(constraints);
            }

            public void populateContext(Collection context) {
                context.add(new AcknowledgmentSource(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean addAcknowledgmentListener(AcknowledgmentSource.Listener listener) {
                        if (listener == null) {
                            throw new NullPointerException();
                        }
                        Object object = Session.this.sessionLock;
                        synchronized (object) {
                            if (Session.this.outState < 2) {
                                if (Session.this.ackListeners == null) {
                                    Session.this.ackListeners = new ArrayList(3);
                                }
                                Session.this.ackListeners.add(listener);
                                return true;
                            }
                            return false;
                        }
                    }
                });
                ((MuxServer)Session.this.mux).populateContext(context);
            }

            public InputStream getRequestInputStream() {
                return Session.this.in;
            }

            public OutputStream getResponseOutputStream() {
                return Session.this.out;
            }

            public void abort() {
                Session.this.abort();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() {
        Object object = this.sessionLock;
        synchronized (object) {
            if (!this.sessionDown) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "outState=" + stateNames[this.outState] + ",inState=" + stateNames[this.inState] + ",role=" + (this.role == 0 ? "CLIENT" : "SERVER"));
                }
                if (this.outState == 0) {
                    this.mux.removeSession(this.sessionID);
                } else if (this.outState < 3) {
                    if (this.role == 1 && this.outState == 2) {
                        this.mux.asyncSendClose(this.sessionID);
                    } else {
                        this.mux.asyncSendAbort(0x20 | (this.role == 1 ? 2 : 0), this.sessionID, null);
                    }
                    this.setOutState(3);
                }
                this.setDown("request aborted", null);
            }
            this.fakeOKtoWrite = false;
            if (this.removeLater) {
                if (this.outState < 3) {
                    this.setOutState(3);
                }
                this.mux.removeSession(this.sessionID);
                this.removeLater = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDown(String message, Throwable cause) {
        Object object = this.sessionLock;
        synchronized (object) {
            if (!this.sessionDown) {
                this.sessionDown = true;
                this.sessionDownMessage = message;
                this.sessionDownCause = cause;
                this.sessionLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleIncrementRation(int increment) throws ProtocolException {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.inState == 0 || this.inState == 3) {
                throw new ProtocolException("IncrementRation on " + stateNames[this.inState] + " session: " + this.sessionID);
            }
            if (!this.outRationInfinite) {
                if (this.outRation + increment < this.outRation) {
                    throw new ProtocolException("ration overflow");
                }
                if (this.outState == 1 && increment > 0) {
                    if (this.outRation == 0) {
                        this.sessionLock.notifyAll();
                    }
                    this.outRation += increment;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAbort(boolean partial) throws ProtocolException {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.inState == 0 || this.inState == 3) {
                throw new ProtocolException("Abort on " + stateNames[this.inState] + " session: " + this.sessionID);
            }
            this.setInState(3);
            this.partialDeliveryStatus = partial;
            if (this.outState < 3) {
                this.mux.asyncSendAbort(0x20 | (this.role == 1 ? 2 : 0), this.sessionID, null);
                this.setOutState(3);
            }
            this.setDown("request aborted by remote endpoint", null);
            if (this.sentAckRequired && !this.receivedAcknowledgment) {
                this.notifyAcknowledgmentListeners(false);
            }
            this.mux.removeSession(this.sessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClose() throws ProtocolException {
        if (this.role != 0) {
            throw new ProtocolException("Close sent by client");
        }
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.inState != 2) {
                throw new ProtocolException("Close on " + stateNames[this.inState] + " session: " + this.sessionID);
            }
            if (this.outState < 2) {
                this.fakeOKtoWrite = true;
                this.mux.asyncSendAbort(32, this.sessionID, null);
                this.setOutState(3);
            }
            this.setInState(3);
            this.setDown("request closed by server", null);
            if (this.outState == 3 || !this.receivedAckRequired || this.sentAcknowledgment) {
                this.mux.removeSession(this.sessionID);
            } else {
                this.removeLater = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAcknowledgment() throws ProtocolException {
        if (this.role != 1) {
            throw new ProtocolException("Acknowledgment sent by server");
        }
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.inState == 0 || this.inState == 3) {
                throw new ProtocolException("Acknowledgment on " + stateNames[this.inState] + " session: " + this.sessionID);
            }
            if (this.outState < 2) {
                throw new ProtocolException("acknowledgment received before EOF sent");
            }
            if (!this.sentAckRequired) {
                throw new ProtocolException("acknowledgment not requested");
            }
            if (this.receivedAcknowledgment) {
                throw new ProtocolException("duplicate acknowledgment");
            }
            this.receivedAcknowledgment = true;
            this.notifyAcknowledgmentListeners(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleData(ByteBuffer data, boolean eof, boolean close, boolean ackRequired) throws ProtocolException {
        assert (eof || !close && !ackRequired);
        if (ackRequired && this.role != 0) {
            throw new ProtocolException("Data/ackRequired sent by client");
        }
        Object object = this.sessionLock;
        synchronized (object) {
            boolean notified = close;
            if (this.inState != 1) {
                throw new ProtocolException("Data on " + stateNames[this.inState] + " session: " + this.sessionID);
            }
            int length = data.remaining();
            if (!this.inRationInfinite && length > this.inRation) {
                throw new ProtocolException("input ration exceeded");
            }
            if (!this.inClosed && this.outState < 3 && length > 0) {
                if (this.inBufRemaining == 0) {
                    this.sessionLock.notifyAll();
                    notified = true;
                }
                this.inBufQueue.addLast(data);
                this.inBufRemaining += length;
                if (!this.inRationInfinite) {
                    this.inRation -= length;
                }
            }
            if (eof) {
                this.inEOF = true;
                this.setInState(2);
                if (!notified) {
                    this.sessionLock.notifyAll();
                }
                if (ackRequired) {
                    this.receivedAckRequired = true;
                }
                if (close) {
                    this.handleClose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOpen() throws ProtocolException {
        assert (this.role == 1);
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.inState < 2 || this.outState < 3) {
                throw new ProtocolException(this.inState < 2 ? "Data/open on " + stateNames[this.inState] + " session: " + this.sessionID : "Data/open before previous session terminated");
            }
            this.setInState(3);
            this.setDown("old request", null);
            this.sessionLock.notifyAll();
            this.mux.removeSession(this.sessionID);
        }
    }

    private void setOutState(int newState) {
        assert (newState > this.outState);
        this.outState = newState;
    }

    private void setInState(int newState) {
        assert (newState > this.inState);
        this.inState = newState;
    }

    private void notifyAcknowledgmentListeners(final boolean received) {
        if (this.ackListeners != null) {
            systemThreadPool.execute(new Runnable(){

                public void run() {
                    for (AcknowledgmentSource.Listener listener : Session.this.ackListeners) {
                        listener.acknowledgmentReceived(received);
                    }
                }
            }, "Mux ack notifier");
        }
    }

    private class MuxInputStream
    extends InputStream {
        MuxInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            Object object = Session.this.sessionLock;
            synchronized (object) {
                if (Session.this.inClosed) {
                    throw new IOException("stream closed");
                }
                while (Session.this.inBufRemaining == 0 && !Session.this.sessionDown && Session.this.inState <= 1 && !Session.this.inClosed) {
                    if (Session.this.inState == 0) {
                        assert (Session.this.outState == 0);
                        Session.this.mux.asyncSendData(144, Session.this.sessionID, null);
                        Session.this.setOutState(1);
                        Session.this.setInState(1);
                    }
                    if (!Session.this.inRationInfinite && Session.this.inRation == 0) {
                        int inc = ((Session)Session.this).mux.initialInboundRation;
                        Session.this.mux.asyncSendIncrementRation(Session.this.sessionID, inc);
                        Session.this.inRation += inc;
                    }
                    try {
                        Session.this.sessionLock.wait();
                    }
                    catch (InterruptedException e) {
                        String message = "request I/O interrupted";
                        Session.this.setDown(message, e);
                        IOException ioe = new IOException(message);
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
                if (Session.this.inClosed) {
                    throw new IOException("stream closed");
                }
                if (Session.this.inBufRemaining == 0) {
                    if (Session.this.inEOF) {
                        return -1;
                    }
                    if (Session.this.inState == 3) {
                        throw new IOException("request aborted by remote endpoint");
                    }
                    assert (Session.this.sessionDown);
                    IOException ioe = new IOException(Session.this.sessionDownMessage);
                    if (Session.this.sessionDownCause != null) {
                        ioe.initCause(Session.this.sessionDownCause);
                    }
                    throw ioe;
                }
                assert (Session.this.inBufQueue.size() > 0);
                int result = -1;
                while (result == -1) {
                    ByteBuffer buf = (ByteBuffer)Session.this.inBufQueue.getFirst();
                    if (Session.this.inBufPos < buf.limit()) {
                        result = buf.get() & 0xFF;
                        Session.this.inBufPos++;
                        Session.this.inBufRemaining--;
                    }
                    if (Session.this.inBufPos != buf.limit()) continue;
                    Session.this.inBufQueue.removeFirst();
                    Session.this.inBufPos = 0;
                }
                if (!Session.this.inRationInfinite) {
                    this.checkInboundRation();
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            Object object = Session.this.sessionLock;
            synchronized (object) {
                if (Session.this.inClosed) {
                    throw new IOException("stream closed");
                }
                if (len == 0) {
                    return 0;
                }
                while (Session.this.inBufRemaining == 0 && !Session.this.sessionDown && Session.this.inState <= 1 && !Session.this.inClosed) {
                    if (Session.this.inState == 0) {
                        assert (Session.this.outState == 0);
                        Session.this.mux.asyncSendData(144, Session.this.sessionID, null);
                        Session.this.setOutState(1);
                        Session.this.setInState(1);
                    }
                    if (!Session.this.inRationInfinite && Session.this.inRation == 0) {
                        int inc = ((Session)Session.this).mux.initialInboundRation;
                        Session.this.mux.asyncSendIncrementRation(Session.this.sessionID, inc);
                        Session.this.inRation += inc;
                    }
                    try {
                        Session.this.sessionLock.wait();
                    }
                    catch (InterruptedException e) {
                        String message = "request I/O interrupted";
                        Session.this.setDown(message, e);
                        IOException ioe = new IOException(message);
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
                if (Session.this.inClosed) {
                    throw new IOException("stream closed");
                }
                if (Session.this.inBufRemaining == 0) {
                    if (Session.this.inEOF) {
                        return -1;
                    }
                    if (Session.this.inState == 3) {
                        throw new IOException("request aborted by remote endpoint");
                    }
                    assert (Session.this.sessionDown);
                    IOException ioe = new IOException(Session.this.sessionDownMessage);
                    if (Session.this.sessionDownCause != null) {
                        ioe.initCause(Session.this.sessionDownCause);
                    }
                    throw ioe;
                }
                assert (Session.this.inBufQueue.size() > 0);
                int remaining = len;
                while (remaining > 0 && Session.this.inBufRemaining > 0) {
                    ByteBuffer buf = (ByteBuffer)Session.this.inBufQueue.getFirst();
                    if (Session.this.inBufPos < buf.limit()) {
                        int toCopy = Math.min(buf.limit() - Session.this.inBufPos, remaining);
                        buf.get(b, off, toCopy);
                        Session.this.inBufPos += toCopy;
                        Session.this.inBufRemaining -= toCopy;
                        off += toCopy;
                        remaining -= toCopy;
                    }
                    if (Session.this.inBufPos != buf.limit()) continue;
                    Session.this.inBufQueue.removeFirst();
                    Session.this.inBufPos = 0;
                }
                if (!Session.this.inRationInfinite) {
                    this.checkInboundRation();
                }
                return len - remaining;
            }
        }

        private void checkInboundRation() {
            assert (Thread.holdsLock(Session.this.sessionLock));
            assert (!Session.this.inRationInfinite);
            if (Session.this.inState >= 2) {
                return;
            }
            int mark = ((Session)Session.this).mux.initialInboundRation / 2;
            int used = Session.this.inBufRemaining + Session.this.inRation;
            if (used <= mark) {
                int inc = ((Session)Session.this).mux.initialInboundRation - used;
                Session.this.mux.asyncSendIncrementRation(Session.this.sessionID, inc);
                Session.this.inRation += inc;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            Object object = Session.this.sessionLock;
            synchronized (object) {
                if (Session.this.inClosed) {
                    throw new IOException("stream closed");
                }
                return Session.this.inBufRemaining;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = Session.this.sessionLock;
            synchronized (object) {
                if (Session.this.inClosed) {
                    return;
                }
                Session.this.inClosed = true;
                Session.this.inBufQueue.clear();
                if (Session.this.role == 0 && !Session.this.sentAcknowledgment && Session.this.receivedAckRequired && Session.this.outState < 3) {
                    Session.this.mux.asyncSendAcknowledgment(Session.this.sessionID);
                    Session.this.sentAcknowledgment = true;
                    if (Session.this.removeLater) {
                        Session.this.setOutState(3);
                        Session.this.mux.removeSession(Session.this.sessionID);
                        Session.this.removeLater = false;
                    }
                }
                Session.this.sessionLock.notifyAll();
            }
        }
    }

    private class MuxOutputStream
    extends OutputStream {
        private ByteBuffer buffer;

        MuxOutputStream() {
            this.buffer = Session.this.mux.directBuffersUseful() ? ByteBuffer.allocateDirect(((Session)Session.this).mux.maxFragmentSize) : ByteBuffer.allocate(((Session)Session.this).mux.maxFragmentSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void write(int b) throws IOException {
            if (!this.buffer.hasRemaining()) {
                this.writeBuffer(false);
            } else {
                Object object = Session.this.sessionLock;
                synchronized (object) {
                    this.ensureOpen();
                }
            }
            this.buffer.put((byte)b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                Object object = Session.this.sessionLock;
                synchronized (object) {
                    this.ensureOpen();
                }
                return;
            }
            while (len > 0) {
                int avail = this.buffer.remaining();
                if (len <= avail) {
                    Object object = Session.this.sessionLock;
                    synchronized (object) {
                        this.ensureOpen();
                    }
                    this.buffer.put(b, off, len);
                    return;
                }
                this.buffer.put(b, off, avail);
                off += avail;
                len -= avail;
                this.writeBuffer(false);
            }
        }

        public synchronized void flush() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "STACK TRACE", new Throwable("STACK TRACE"));
            }
            Object object = Session.this.sessionLock;
            synchronized (object) {
                this.ensureOpen();
            }
            while (!this.writeBuffer(true)) {
            }
        }

        private void ensureOpen() throws IOException {
            assert (Thread.holdsLock(Session.this.sessionLock));
            if (Session.this.fakeOKtoWrite) {
                return;
            }
            if (Session.this.outState > 1) {
                if (Session.this.outState == 2) {
                    throw new IOException("stream closed");
                }
                throw new IOException("session terminated");
            }
            if (Session.this.sessionDown) {
                IOException ioe = new IOException(Session.this.sessionDownMessage);
                if (Session.this.sessionDownCause != null) {
                    ioe.initCause(Session.this.sessionDownCause);
                }
                throw ioe;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean writeBuffer(boolean closeIfComplete) throws IOException {
            this.buffer.flip();
            int origLimit = this.buffer.limit();
            IOFuture future = null;
            boolean eofSent = false;
            Object object = Session.this.sessionLock;
            synchronized (object) {
                boolean complete;
                int toSend;
                while (this.buffer.remaining() > 0 && !Session.this.outRationInfinite && Session.this.outRation < 1 && !Session.this.sessionDown && Session.this.outState == 1) {
                    try {
                        Session.this.sessionLock.wait();
                    }
                    catch (InterruptedException e) {
                        String message = "request I/O interrupted";
                        Session.this.setDown(message, e);
                        IOException ioe = new IOException(message);
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
                this.ensureOpen();
                assert (this.buffer.remaining() == 0 || Session.this.outRationInfinite || Session.this.outRation > 0 || Session.this.fakeOKtoWrite);
                if (Session.this.fakeOKtoWrite) {
                    assert (Session.this.role == 0 && Session.this.inState == 3);
                    if (closeIfComplete) {
                        Session.this.fakeOKtoWrite = false;
                    }
                    this.buffer.position(origLimit);
                    this.buffer.compact();
                    return closeIfComplete;
                }
                if (Session.this.outRationInfinite || this.buffer.remaining() <= Session.this.outRation) {
                    toSend = this.buffer.remaining();
                    complete = true;
                } else {
                    toSend = Session.this.outRation;
                    this.buffer.limit(toSend);
                    complete = false;
                }
                if (!Session.this.outRationInfinite) {
                    Session.this.outRation -= toSend;
                }
                Session.this.partialDeliveryStatus = true;
                boolean open = Session.this.outState == 0;
                boolean eof = closeIfComplete && complete;
                boolean close = Session.this.role == 1 && eof && Session.this.inState > 1;
                boolean ackRequired = Session.this.role == 1 && eof && Session.this.ackListeners != null && !Session.this.ackListeners.isEmpty();
                int op = 0x80 | (open ? 16 : 0) | (eof ? 4 : 0) | (close ? 8 : 0) | (ackRequired ? 2 : 0);
                if (!eof || Session.this.role == 1) {
                    future = Session.this.mux.futureSendData(op, Session.this.sessionID, this.buffer);
                } else {
                    Session.this.mux.asyncSendData(op, Session.this.sessionID, this.buffer);
                }
                if (Session.this.outState == 0) {
                    Session.this.setOutState(1);
                    Session.this.setInState(1);
                }
                if (eof) {
                    eofSent = true;
                    Session.this.setOutState(close ? 3 : 2);
                    if (ackRequired) {
                        Session.this.sentAckRequired = true;
                    }
                    Session.this.sessionLock.notifyAll();
                }
            }
            if (future != null) {
                this.waitForIO(future);
                this.buffer.limit(origLimit);
                this.buffer.compact();
            }
            return eofSent;
        }

        private void waitForIO(IOFuture future) throws IOException {
            assert (!Thread.holdsLock(Session.this.sessionLock));
            try {
                future.waitUntilDone();
            }
            catch (InterruptedException e) {
                String message = "request I/O interrupted";
                Session.this.setDown(message, e);
                IOException ioe = new IOException(message);
                ioe.initCause(e);
                throw ioe;
            }
            catch (IOException e) {
                Session.this.setDown(e.getMessage(), e.getCause());
                throw e;
            }
        }
    }
}

