/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.tcp;

import com.sun.jini.action.GetBooleanAction;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import com.sun.jini.logging.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.ConnectionEndpoint;
import net.jini.jeri.connection.ConnectionManager;
import net.jini.jeri.connection.OutboundRequestHandle;
import net.jini.jeri.tcp.Constraints;
import net.jini.security.proxytrust.TrustEquivalence;

public final class TcpEndpoint
implements Endpoint,
TrustEquivalence,
Serializable {
    private static final long serialVersionUID = -2840731722681368933L;
    private static final Map internTable = new WeakHashMap();
    private static final Logger logger = Logger.getLogger("net.jini.jeri.tcp.client");
    private static final boolean useNIO = (Boolean)AccessController.doPrivileged(new GetBooleanAction("com.sun.jini.jeri.tcp.useNIO"));
    private final String host;
    private final int port;
    private final SocketFactory sf;
    private transient ConnectionManager connectionManager;

    public static TcpEndpoint getInstance(String host, int port) {
        return TcpEndpoint.intern(new TcpEndpoint(host, port, null));
    }

    public static TcpEndpoint getInstance(String host, int port, SocketFactory sf) {
        return TcpEndpoint.intern(new TcpEndpoint(host, port, sf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TcpEndpoint intern(TcpEndpoint endpoint) {
        Map map = internTable;
        synchronized (map) {
            TcpEndpoint canonical;
            WeakReference ref = (WeakReference)internTable.get(endpoint);
            if (ref != null && (canonical = (TcpEndpoint)ref.get()) != null) {
                return canonical;
            }
            endpoint.connectionManager = new ConnectionManager(endpoint.new ConnectionEndpointImpl());
            internTable.put(endpoint, new WeakReference<TcpEndpoint>(endpoint));
            return endpoint;
        }
    }

    private TcpEndpoint(String host, int port, SocketFactory sf) {
        if (host == null) {
            throw new NullPointerException();
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("port number out of range: " + port);
        }
        this.host = host;
        this.port = port;
        this.sf = sf;
    }

    private Object readResolve() {
        return TcpEndpoint.intern(this);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public SocketFactory getSocketFactory() {
        return this.sf;
    }

    public OutboundRequestIterator newRequest(InvocationConstraints constraints) {
        if (constraints == null) {
            throw new NullPointerException();
        }
        try {
            Constraints.Distilled distilled = Constraints.distill(constraints, false);
            return this.connectionManager.newRequest(new Handle(distilled));
        }
        catch (UnsupportedConstraintException e) {
            return new OutboundRequestIterator(){
                private boolean nextCalled = false;

                public boolean hasNext() {
                    return !this.nextCalled;
                }

                public OutboundRequest next() throws IOException {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.nextCalled = true;
                    e.fillInStackTrace();
                    throw e;
                }
            };
        }
    }

    public int hashCode() {
        return this.host.hashCode() ^ this.port ^ (this.sf != null ? this.sf.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TcpEndpoint)) {
            return false;
        }
        TcpEndpoint other = (TcpEndpoint)obj;
        return this.host.equals(other.host) && this.port == other.port && Util.sameClassAndEquals(this.sf, other.sf);
    }

    public boolean checkTrustEquivalence(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TcpEndpoint)) {
            return false;
        }
        TcpEndpoint other = (TcpEndpoint)obj;
        return this.host.equals(other.host) && this.port == other.port && Util.sameClassAndEquals(this.sf, other.sf);
    }

    public String toString() {
        return "TcpEndpoint[" + this.host + ":" + this.port + (this.sf != null ? "," + this.sf : "") + "]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.host == null) {
            throw new InvalidObjectException("null host");
        }
        if (this.port < 1 || this.port > 65535) {
            throw new InvalidObjectException("port number out of range: " + this.port);
        }
    }

    private static void setSocketOptions(Socket socket) {
        block5: {
            block4: {
                try {
                    socket.setTcpNoDelay(true);
                }
                catch (SocketException e) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block4;
                    LogUtil.logThrow(logger, Levels.HANDLED, TcpEndpoint.class, "setSocketOptions", "exception setting TCP_NODELAY on socket {0}", new Object[]{socket}, e);
                }
            }
            try {
                socket.setKeepAlive(true);
            }
            catch (SocketException e) {
                if (!logger.isLoggable(Levels.HANDLED)) break block5;
                LogUtil.logThrow(logger, Levels.HANDLED, TcpEndpoint.class, "setSocketOptions", "exception setting SO_KEEPALIVE on socket {0}", new Object[]{socket}, e);
            }
        }
    }

    private static class ConnectionImpl
    implements Connection {
        private final Socket socket;
        private final InetSocketAddress inetSocketAddress;
        private final int socketPort;

        ConnectionImpl(Socket socket) {
            assert (socket.isConnected());
            this.socket = socket;
            this.inetSocketAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
            this.socketPort = socket.getPort();
        }

        Socket getSocket() {
            return this.socket;
        }

        public InputStream getInputStream() throws IOException {
            return this.socket.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            return this.socket.getOutputStream();
        }

        public SocketChannel getChannel() {
            return this.socket.getChannel();
        }

        public void populateContext(OutboundRequestHandle handle, Collection context) {
            if (context == null) {
                throw new NullPointerException();
            }
        }

        public InvocationConstraints getUnfulfilledConstraints(OutboundRequestHandle handle) {
            Handle h = (Handle)handle;
            return h.getUnfulfilledConstraints();
        }

        public void writeRequestData(OutboundRequestHandle handle, OutputStream out) {
            if (out == null) {
                throw new NullPointerException();
            }
        }

        public IOException readResponseData(OutboundRequestHandle handle, InputStream in) {
            if (in == null) {
                throw new NullPointerException();
            }
            return null;
        }

        public void close() {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "closed socket {0}", this.socket);
            }
        }

        void checkConnectPermission() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                if (this.inetSocketAddress.isUnresolved()) {
                    sm.checkConnect(this.inetSocketAddress.getHostName(), this.socketPort);
                } else {
                    sm.checkConnect(this.inetSocketAddress.getAddress().getHostAddress(), this.socketPort);
                }
            }
        }
    }

    private class ConnectionEndpointImpl
    implements ConnectionEndpoint {
        ConnectionEndpointImpl() {
        }

        public Connection connect(OutboundRequestHandle handle) throws IOException {
            Handle h = (Handle)handle;
            Constraints.Distilled distilled = h.getDistilledConstraints();
            Socket socket = this.connectToHost(distilled);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "connected socket {0}", socket);
            }
            TcpEndpoint.setSocketOptions(socket);
            return new ConnectionImpl(socket);
        }

        private Socket connectToHost(Constraints.Distilled distilled) throws IOException {
            InetAddress[] addresses;
            try {
                addresses = InetAddress.getAllByName(TcpEndpoint.this.host);
            }
            catch (UnknownHostException uhe) {
                try {
                    return this.connectToSocketAddress(new InetSocketAddress(TcpEndpoint.this.host, TcpEndpoint.this.port), distilled);
                }
                catch (IOException e) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        LogUtil.logThrow(logger, Levels.FAILED, ConnectionEndpointImpl.class, "connectToHost", "exception connecting to unresolved host {0}", new Object[]{TcpEndpoint.this.host + ":" + TcpEndpoint.this.port}, e);
                    }
                    throw e;
                }
                catch (SecurityException e) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        LogUtil.logThrow(logger, Levels.FAILED, ConnectionEndpointImpl.class, "connectToHost", "exception connecting to unresolved host {0}", new Object[]{TcpEndpoint.this.host + ":" + TcpEndpoint.this.port}, e);
                    }
                    throw e;
                }
            }
            catch (SecurityException e) {
                if (logger.isLoggable(Levels.FAILED)) {
                    LogUtil.logThrow(logger, Levels.FAILED, ConnectionEndpointImpl.class, "connectToHost", "exception resolving host {0}", new Object[]{TcpEndpoint.this.host}, e);
                }
                throw e;
            }
            IOException lastIOException = null;
            SecurityException lastSecurityException = null;
            for (int i = 0; i < addresses.length; ++i) {
                InetSocketAddress socketAddress = new InetSocketAddress(addresses[i], TcpEndpoint.this.port);
                try {
                    return this.connectToSocketAddress(socketAddress, distilled);
                }
                catch (IOException e) {
                    if (logger.isLoggable(Levels.HANDLED)) {
                        LogUtil.logThrow(logger, Levels.HANDLED, ConnectionEndpointImpl.class, "connectToHost", "exception connecting to {0}", new Object[]{socketAddress}, e);
                    }
                    lastIOException = e;
                    if (!(e instanceof SocketTimeoutException)) continue;
                    break;
                }
                catch (SecurityException e) {
                    if (logger.isLoggable(Levels.HANDLED)) {
                        LogUtil.logThrow(logger, Levels.HANDLED, ConnectionEndpointImpl.class, "connectToHost", "exception connecting to {0}", new Object[]{socketAddress}, e);
                    }
                    lastSecurityException = e;
                }
            }
            if (lastIOException != null) {
                if (logger.isLoggable(Levels.FAILED)) {
                    LogUtil.logThrow(logger, Levels.FAILED, ConnectionEndpointImpl.class, "connectToHost", "exception connecting to {0}", new Object[]{TcpEndpoint.this.host + ":" + TcpEndpoint.this.port}, lastIOException);
                }
                throw lastIOException;
            }
            assert (lastSecurityException != null);
            if (logger.isLoggable(Levels.FAILED)) {
                LogUtil.logThrow(logger, Levels.FAILED, ConnectionEndpointImpl.class, "connectToHost", "exception connecting to {0}", new Object[]{TcpEndpoint.this.host + ":" + TcpEndpoint.this.port}, lastSecurityException);
            }
            throw lastSecurityException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Socket connectToSocketAddress(SocketAddress socketAddress, Constraints.Distilled distilled) throws IOException {
            Socket socket;
            block9: {
                int timeout;
                if (distilled.hasConnectDeadline()) {
                    long now = System.currentTimeMillis();
                    long deadline = distilled.getConnectDeadline();
                    if (deadline <= now) {
                        throw new SocketTimeoutException("deadline past before connect attempt");
                    }
                    assert (now > 0L);
                    long delta = deadline - now;
                    timeout = delta > Integer.MAX_VALUE ? 0 : (int)delta;
                } else {
                    timeout = 0;
                }
                Socket socket2 = this.newSocket();
                boolean ok = false;
                try {
                    socket2.connect(socketAddress, timeout);
                    ok = true;
                    socket = socket2;
                    Object var11_10 = null;
                    if (ok) break block9;
                }
                catch (Throwable throwable) {
                    block10: {
                        Object var11_11 = null;
                        if (ok) break block10;
                        try {
                            socket2.close();
                        }
                        catch (IOException e) {}
                    }
                    throw throwable;
                }
                try {
                    socket2.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return socket;
        }

        private Socket newSocket() throws IOException {
            Socket socket = TcpEndpoint.this.sf != null ? TcpEndpoint.this.sf.createSocket() : (useNIO ? SocketChannel.open().socket() : new Socket());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, TcpEndpoint.this.sf == null ? "created socket {0}" : "created socket {0} using factory {1}", new Object[]{socket, TcpEndpoint.this.sf});
            }
            return socket;
        }

        public Connection connect(OutboundRequestHandle handle, Collection active, Collection idle) {
            if (active == null || idle == null) {
                throw new NullPointerException();
            }
            boolean checkedResolvePermission = false;
            for (ConnectionImpl c : active) {
                if (!checkedResolvePermission) {
                    try {
                        this.checkResolvePermission();
                    }
                    catch (SecurityException e) {
                        if (logger.isLoggable(Levels.FAILED)) {
                            LogUtil.logThrow(logger, Levels.FAILED, ConnectionEndpointImpl.class, "connect", "exception resolving host {0}", new Object[]{TcpEndpoint.this.host}, e);
                        }
                        throw e;
                    }
                    checkedResolvePermission = true;
                }
                try {
                    c.checkConnectPermission();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "reusing connection {0}", c.getSocket());
                    }
                    return c;
                }
                catch (SecurityException e) {
                    if (!logger.isLoggable(Levels.HANDLED)) continue;
                    LogUtil.logThrow(logger, Levels.HANDLED, ConnectionEndpointImpl.class, "connect", "access to reuse connection {0} denied", new Object[]{c.getSocket()}, e);
                }
            }
            for (ConnectionImpl c : idle) {
                if (!checkedResolvePermission) {
                    try {
                        this.checkResolvePermission();
                    }
                    catch (SecurityException e) {
                        if (logger.isLoggable(Levels.FAILED)) {
                            LogUtil.logThrow(logger, Levels.FAILED, ConnectionEndpointImpl.class, "connect", "exception resolving host {0}", new Object[]{TcpEndpoint.this.host}, e);
                        }
                        throw e;
                    }
                    checkedResolvePermission = true;
                }
                try {
                    c.checkConnectPermission();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "reusing connection {0}", c.getSocket());
                    }
                    return c;
                }
                catch (SecurityException e) {
                    if (!logger.isLoggable(Levels.HANDLED)) continue;
                    LogUtil.logThrow(logger, Levels.HANDLED, ConnectionEndpointImpl.class, "connect", "access to reuse connection {0} denied", new Object[]{c.getSocket()}, e);
                }
            }
            return null;
        }

        private void checkResolvePermission() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkConnect(TcpEndpoint.this.host, -1);
            }
        }
    }

    private class Handle
    implements OutboundRequestHandle {
        private final Constraints.Distilled distilled;

        Handle(Constraints.Distilled distilled) {
            this.distilled = distilled;
        }

        TcpEndpoint getTcpEndpoint() {
            return TcpEndpoint.this;
        }

        Constraints.Distilled getDistilledConstraints() {
            return this.distilled;
        }

        InvocationConstraints getUnfulfilledConstraints() {
            return this.distilled.getUnfulfilledConstraints();
        }
    }
}

