/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security;

import java.rmi.RemoteException;
import java.security.Permission;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.security.ProxyPreparer;
import net.jini.security.Security;

public final class VerifyingProxyPreparer
implements ProxyPreparer {
    private static final int SET_CONSTRAINTS = 1;
    private static final int AS_IS = 2;
    private static final int ADD_CONSTRAINTS = 3;
    private final int type;
    private final ClassLoader loader;
    private final Object[] contextElements;
    private final Principal[] principals;
    private final Permission[] permissions;

    public VerifyingProxyPreparer(Object[] contextElements, Permission[] permissions) {
        this(null, contextElements, null, permissions);
    }

    public VerifyingProxyPreparer(ClassLoader loader, Object[] contextElements, Principal[] principals, Permission[] permissions) {
        this.type = 1;
        this.loader = loader;
        this.contextElements = (Object[])contextElements.clone();
        this.principals = VerifyingProxyPreparer.checkPrincipals(principals);
        this.permissions = VerifyingProxyPreparer.checkPermissions(permissions);
        int i = this.contextElements.length;
        while (--i >= 0) {
            if (!(this.contextElements[i] instanceof MethodConstraints)) continue;
            return;
        }
        throw new IllegalArgumentException("no MethodConstraints in context");
    }

    public VerifyingProxyPreparer(boolean addProxyConstraints, ClassLoader loader, Object[] contextElements, Principal[] principals, Permission[] permissions) {
        this.type = addProxyConstraints ? 3 : 2;
        this.loader = loader;
        this.contextElements = contextElements == null ? new Object[]{} : (Object[])contextElements.clone();
        this.principals = VerifyingProxyPreparer.checkPrincipals(principals);
        this.permissions = VerifyingProxyPreparer.checkPermissions(permissions);
    }

    private static Permission[] checkPermissions(Permission[] permissions) {
        if (permissions == null) {
            return new Permission[0];
        }
        permissions = (Permission[])permissions.clone();
        int i = permissions.length;
        while (--i >= 0) {
            if (permissions[i] != null) continue;
            throw new NullPointerException("permission cannot be null");
        }
        return permissions;
    }

    private static Principal[] checkPrincipals(Principal[] principals) {
        if (principals == null) {
            return null;
        }
        principals = (Principal[])principals.clone();
        int i = principals.length;
        while (--i >= 0) {
            if (principals[i] != null) continue;
            throw new NullPointerException("principal cannot be null");
        }
        return principals;
    }

    public Object prepareProxy(Object proxy) throws RemoteException {
        if (proxy == null) {
            throw new NullPointerException("proxy cannot be null");
        }
        if (this.type != 2 && !(proxy instanceof RemoteMethodControl)) {
            throw new SecurityException("proxy must implement RemoteMethodControl");
        }
        Object[] elts = this.contextElements;
        if (this.type == 3) {
            elts = new Object[this.contextElements.length + 1];
            elts[0] = ((RemoteMethodControl)proxy).getConstraints();
            System.arraycopy(this.contextElements, 0, elts, 1, this.contextElements.length);
        }
        Security.verifyObjectTrust(proxy, this.loader, Collections.unmodifiableCollection(Arrays.asList(elts)));
        if (this.permissions.length > 0) {
            try {
                if (this.principals == null) {
                    Security.grant(proxy.getClass(), this.permissions);
                } else {
                    Security.grant(proxy.getClass(), this.principals, this.permissions);
                }
            }
            catch (UnsupportedOperationException e) {
                SecurityException se = new SecurityException("dynamic permission grants are not supported");
                se.initCause(e);
                throw se;
            }
        }
        if (this.type == 1) {
            for (int i = 0; i < this.contextElements.length; ++i) {
                Object elt = this.contextElements[i];
                if (!(elt instanceof MethodConstraints)) continue;
                return ((RemoteMethodControl)proxy).setConstraints((MethodConstraints)elt);
            }
        }
        return proxy;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer("VerifyingProxyPreparer[");
        if (this.type != 1) {
            sb.append(this.type == 2 ? "false, " : "true, ");
        }
        sb.append(this.loader);
        sb.append(", {");
        for (i = 0; i < this.contextElements.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.contextElements[i]);
        }
        if (this.principals == null) {
            sb.append("}, null, {");
        } else {
            sb.append("}, {");
            for (i = 0; i < this.principals.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.principals[i]);
            }
            sb.append("}, {");
        }
        for (i = 0; i < this.permissions.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.permissions[i]);
        }
        sb.append("}]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        int j;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VerifyingProxyPreparer)) {
            return false;
        }
        VerifyingProxyPreparer other = (VerifyingProxyPreparer)obj;
        if (this.type != other.type || this.loader != other.loader || this.contextElements.length != other.contextElements.length || this.principals == null != (other.principals == null) || this.principals != null && this.principals.length != other.principals.length || this.permissions.length != other.permissions.length) {
            return false;
        }
        Object[] otherElts = (Object[])other.contextElements.clone();
        int i = this.contextElements.length;
        block0: while (--i >= 0) {
            Object elt = this.contextElements[i];
            for (int j2 = i; j2 >= 0; --j2) {
                if (!elt.equals(otherElts[j2])) continue;
                otherElts[j2] = otherElts[i];
                continue block0;
            }
            return false;
        }
        if (this.principals != null) {
            Principal[] otherPrins = (Principal[])other.principals.clone();
            int i2 = this.principals.length;
            block2: while (--i2 >= 0) {
                Principal p = this.principals[i2];
                for (j = i2; j >= 0; --j) {
                    if (!p.equals(otherPrins[j])) continue;
                    otherPrins[j] = otherPrins[i2];
                    continue block2;
                }
                return false;
            }
        }
        Permission[] otherPerms = (Permission[])other.permissions.clone();
        int i3 = this.permissions.length;
        block4: while (--i3 >= 0) {
            Permission p = this.permissions[i3];
            for (j = i3; j >= 0; --j) {
                if (!p.equals(otherPerms[j])) continue;
                otherPerms[j] = otherPerms[i3];
                continue block4;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.type;
        if (this.loader != null) {
            hash += this.loader.hashCode();
        }
        int i = this.contextElements.length;
        while (--i >= 0) {
            hash += this.contextElements[i].hashCode();
        }
        if (this.principals != null) {
            i = this.principals.length;
            while (--i >= 0) {
                hash += this.principals[i].hashCode();
            }
        }
        i = this.permissions.length;
        while (--i >= 0) {
            hash += this.permissions[i].hashCode();
        }
        return hash;
    }
}

