/*
 * Decompiled with CFR 0.152.
 */
package net.jini.config;

import com.sun.jini.logging.Levels;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationFile;
import net.jini.config.Utilities;
import net.jini.security.Security;

public class ConfigurationProvider {
    private static final String resourceName = "META-INF/services/" + Configuration.class.getName();
    private static final Logger logger = Logger.getLogger("net.jini.config");

    private ConfigurationProvider() {
        throw new AssertionError();
    }

    public static Configuration getInstance(String[] options) throws ConfigurationException {
        return ConfigurationProvider.getInstance(options, null);
    }

    public static Configuration getInstance(String[] options, ClassLoader cl) throws ConfigurationException {
        ClassLoader resourceLoader = cl;
        if (resourceLoader == null) {
            logger.fine("Null class loader provided, fetching context class loader...");
            resourceLoader = cl != null ? cl : (ClassLoader)Security.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            logger.fine("...resource class loader is now: " + resourceLoader);
        }
        final ClassLoader finalResourceLoader = resourceLoader == null ? Utilities.bootstrapResourceLoader : resourceLoader;
        logger.fine("Final resource class loader is: " + finalResourceLoader);
        String cname = null;
        ConfigurationException configEx = null;
        try {
            cname = (String)Security.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigurationException, IOException {
                    URL resource = null;
                    Enumeration<URL> providers = finalResourceLoader.getResources(resourceName);
                    while (providers.hasMoreElements()) {
                        resource = providers.nextElement();
                    }
                    return resource == null ? null : ConfigurationProvider.getProviderName(resource);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception e2 = e.getException();
            configEx = e2 instanceof ConfigurationException ? (ConfigurationException)e2 : new ConfigurationException("problem accessing provider resources", e2);
        }
        catch (RuntimeException e) {
            configEx = new ConfigurationException("problem accessing provider resources", e);
        }
        if (configEx != null) {
            logger.log(Levels.FAILED, "getting configuration provider throws", configEx);
            throw configEx;
        }
        if (cname == null) {
            return new ConfigurationFile(options, cl);
        }
        try {
            Class<?> cls = Class.forName(cname, true, resourceLoader);
            if (Configuration.class.isAssignableFrom(cls)) {
                Constructor<?> cons = cls.getConstructor(String[].class, ClassLoader.class);
                return (Configuration)cons.newInstance(options, cl);
            }
            configEx = new ConfigurationException("provider class " + cname + " does not implement Configuration");
        }
        catch (ClassNotFoundException e) {
            configEx = new ConfigurationException("provider class " + cname + " not found");
        }
        catch (NoSuchMethodException e) {
            configEx = new ConfigurationException("provider class " + cname + " does not have the right constructor");
        }
        catch (IllegalAccessException e) {
            configEx = new ConfigurationException("provider class " + cname + " constructor is not public");
        }
        catch (InstantiationException e) {
            configEx = new ConfigurationException("provider class " + cname + " is abstract");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            configEx = t instanceof ConfigurationException ? (ConfigurationException)t : new ConfigurationException("problem with provider class", t);
        }
        catch (RuntimeException e) {
            configEx = new ConfigurationException("problem with provider class", e);
        }
        logger.log(Levels.FAILED, "getting configuration throws", configEx);
        throw configEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProviderName(URL url) throws ConfigurationException, IOException {
        String string;
        block9: {
            InputStream in = null;
            try {
                String line;
                in = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "utf-8"));
                String result = null;
                while ((line = reader.readLine()) != null) {
                    int len;
                    int commentPos = line.indexOf(35);
                    if (commentPos >= 0) {
                        line = line.substring(0, commentPos);
                    }
                    if ((len = (line = line.trim()).length()) == 0) continue;
                    if (result != null) {
                        throw new ConfigurationException("resource specifies multiple providers");
                    }
                    result = line;
                }
                if (result == null) {
                    throw new ConfigurationException("resource specifies no providers");
                }
                string = result;
                Object var8_7 = null;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var8_8 = null;
                    if (in == null) break block10;
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return string;
    }
}

